/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram;

import com.baselet.control.basics.Converter;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DiagramNotification;
import com.baselet.diagram.DrawPanel;
import java.awt.Rectangle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;

public class Notifier {
    private static final Notifier instance = new Notifier();

    public static synchronized Notifier getInstance() {
        return instance;
    }

    public void showNotification(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Notifier.this.showNotificationHelper(message);
            }
        });
    }

    private void showNotificationHelper(String message) {
        final DrawPanel notifierPanel = CurrentDiagram.getInstance().getDiagramHandler().getDrawPanel();
        Rectangle viewRect = notifierPanel.getScrollPane().getViewport().getViewRect();
        final DiagramNotification notification = new DiagramNotification(Converter.convert(viewRect), message);
        new Timer("Notificationtimer", true).schedule(new TimerTask(){

            @Override
            public void run() {
                notifierPanel.remove(notification);
                notifierPanel.repaint();
            }
        }, 3000L);
        notifierPanel.setNotification(notification);
    }
}

