/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram.io;

import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.enums.ElementId;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.DrawPanel;
import com.baselet.element.ElementFactorySwing;
import com.baselet.element.NewGridElement;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.old.custom.CustomElementCompiler;
import com.baselet.element.old.element.ErrorOccurred;
import com.baselet.gui.BaseGUI;
import com.baselet.gui.CurrentGui;
import com.baselet.gui.command.HelpPanelChanged;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class InputHandler
extends DefaultHandler {
    private static final String[] oldGridElementPackages = new String[]{"com.baselet.element.old.element", "com.baselet.element.old.allinone", "com.baselet.element.old.custom"};
    private static final Logger log = Logger.getLogger(InputHandler.class);
    private DrawPanel _p = null;
    private GridElement e = null;
    private String elementtext;
    private int x;
    private int y;
    private int w;
    private int h;
    private String entityname;
    private String code;
    private String panel_attributes;
    private String additional_attributes;
    private Integer currentGroup;
    private final DiagramHandler handler;
    private final List<String> ignoreElements;
    private String id;

    public InputHandler(DiagramHandler handler) {
        this.handler = handler;
        this._p = handler.getDrawPanel();
        this.ignoreElements = new ArrayList<String>();
        this.ignoreElements.add("main.control.Group");
        this.currentGroup = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.elementtext = "";
        if (qName.equals("element")) {
            this.panel_attributes = "";
            this.additional_attributes = "";
            this.code = null;
        }
        if (qName.equals("group")) {
            this.currentGroup = this.handler.getDrawPanel().getSelector().getUnusedGroup();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        String elementname = qName;
        if (elementname.equals("help_text")) {
            this.handler.setHelpText(this.elementtext);
            this.handler.getFontHandler().setDiagramDefaultFontSize(HelpPanelChanged.getFontsize(this.elementtext));
            this.handler.getFontHandler().setDiagramDefaultFontFamily(HelpPanelChanged.getFontfamily(this.elementtext));
            BaseGUI gui = CurrentGui.getInstance().getGui();
            if (gui != null && gui.getPropertyPane() != null) {
                gui.getPropertyPane().switchToNonElement(this.elementtext);
            }
        } else if (elementname.equals("zoom_level")) {
            if (this.handler != null) {
                this.handler.setGridSize(Integer.parseInt(this.elementtext));
            }
        } else if (elementname.equals("group")) {
            this.currentGroup = null;
        } else if (elementname.equals("element")) {
            if (this.id != null) {
                try {
                    NewGridElement e = ElementFactorySwing.create(ElementId.valueOf(this.id), new Rectangle(this.x, this.y, this.w, this.h), this.panel_attributes, this.additional_attributes, this.handler);
                    if (this.currentGroup != null) {
                        e.setProperty("group", this.currentGroup);
                    }
                    this._p.addElement(e);
                }
                catch (Exception e) {
                    log.error((Object)("Cannot instantiate element with id: " + this.id), (Throwable)e);
                }
                this.id = null;
            } else if (!this.ignoreElements.contains(this.entityname)) {
                try {
                    this.e = this.code == null ? InputHandler.getOldGridElementFromPath(this.entityname) : CustomElementCompiler.getInstance().genEntity(this.code);
                }
                catch (InstantiationException e1) {
                    this.e = new ErrorOccurred();
                }
                catch (IllegalAccessException e1) {
                    this.e = new ErrorOccurred();
                }
                catch (ClassNotFoundException e1) {
                    this.e = new ErrorOccurred();
                }
                this.e.setRectangle(new Rectangle(this.x, this.y, this.w, this.h));
                this.e.setPanelAttributes(this.panel_attributes);
                this.e.setAdditionalAttributes(this.additional_attributes);
                this.handler.setHandlerAndInitListeners(this.e);
                if (this.currentGroup != null) {
                    this.e.setProperty("group", this.currentGroup);
                }
                this._p.addElement(this.e);
            }
        } else if (elementname.equals("type")) {
            this.entityname = this.elementtext;
        } else if (elementname.equals("id")) {
            this.id = this.elementtext;
        } else if (elementname.equals("x")) {
            Integer i = Integer.valueOf(this.elementtext);
            this.x = i;
        } else if (elementname.equals("y")) {
            Integer i = Integer.valueOf(this.elementtext);
            this.y = i;
        } else if (elementname.equals("w")) {
            Integer i = Integer.valueOf(this.elementtext);
            this.w = i;
        } else if (elementname.equals("h")) {
            Integer i = Integer.valueOf(this.elementtext);
            this.h = i;
        } else if (elementname.equals("panel_attributes")) {
            this.panel_attributes = this.elementtext;
        } else if (elementname.equals("additional_attributes")) {
            this.additional_attributes = this.elementtext;
        } else if (elementname.equals("custom_code")) {
            this.code = this.elementtext;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.elementtext = String.valueOf(this.elementtext) + new String(ch).substring(start, start + length);
    }

    private static GridElement getOldGridElementFromPath(String path) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> foundClass = null;
        String className = path.substring(path.lastIndexOf("."));
        String[] stringArray = oldGridElementPackages;
        int n = oldGridElementPackages.length;
        int n2 = 0;
        while (n2 < n) {
            String possPackage = stringArray[n2];
            try {
                foundClass = Thread.currentThread().getContextClassLoader().loadClass(String.valueOf(possPackage) + className);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                ++n2;
            }
        }
        if (foundClass == null) {
            ClassNotFoundException ex = new ClassNotFoundException("class " + path + " not found");
            log.error(null, (Throwable)ex);
            throw ex;
        }
        return (GridElement)foundClass.newInstance();
    }
}

