/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.elementnew.plot.drawer;

import com.baselet.control.basics.geom.Dimension;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;

public class Canvas {
    private int borderspace;
    private Rectangle outerBorder;
    private Rectangle innerBorder;
    private Dimension gridElementSize;

    public Canvas(Dimension dimension) {
        this.gridElementSize = dimension;
        this.outerBorder = new Rectangle();
        this.innerBorder = new Rectangle();
        this.setBorder(0, 0, 0, 0, 0);
    }

    public void setBorder(int n, int n2, int n3, int n4, int n5) {
        this.borderspace = n5;
        this.outerBorder.setBounds(n, n2, n3, n4);
        this.updateInnerBorder();
    }

    public void setBorderX(int n) {
        this.outerBorder.setBounds(n, this.outerBorder.y, this.outerBorder.width, this.outerBorder.height);
        this.updateInnerBorder();
    }

    public void setBorderY(int n) {
        this.outerBorder.setBounds(this.outerBorder.x, n, this.outerBorder.width, this.outerBorder.height);
        this.updateInnerBorder();
    }

    public void setBorderWidth(int n) {
        this.outerBorder.setBounds(this.outerBorder.x, this.outerBorder.y, n, this.outerBorder.height);
        this.updateInnerBorder();
    }

    public void setBorderHeight(int n) {
        this.outerBorder.setBounds(this.outerBorder.x, this.outerBorder.y, this.outerBorder.width, n);
        this.updateInnerBorder();
    }

    private void updateInnerBorder() {
        this.innerBorder.setBounds(this.outerBorder.x + this.borderspace, this.outerBorder.y + this.borderspace, this.outerBorder.width + this.borderspace, this.outerBorder.height + this.borderspace);
    }

    public int getInnerLeftPos() {
        return this.innerBorder.x;
    }

    public int getInnerUpPos() {
        return this.innerBorder.y;
    }

    public int getInnerRightBorderWidth() {
        return this.innerBorder.width;
    }

    public int getInnerDownBorderHeight() {
        return this.innerBorder.height;
    }

    public int getInnerRightPos() {
        return this.gridElementSize.width - this.getInnerRightBorderWidth();
    }

    public int getInnerDownPos() {
        return this.gridElementSize.height - this.getInnerDownBorderHeight();
    }

    public int getInnerHorizontalSum() {
        return this.getInnerLeftPos() + this.getInnerRightBorderWidth();
    }

    public int getInnerVerticalSum() {
        return this.getInnerUpPos() + this.getInnerDownBorderHeight();
    }

    public int getInnerHorizontalDrawspace() {
        return this.getInnerRightPos() - this.getInnerLeftPos();
    }

    public int getInnerVerticalDrawspace() {
        return this.getInnerDownPos() - this.getInnerUpPos();
    }

    public int getOuterLeftPos() {
        return this.outerBorder.x;
    }

    public int getOuterUpPos() {
        return this.outerBorder.y;
    }

    public int getOuterRightBorderWidth() {
        return this.outerBorder.width;
    }

    public int getOuterDownBorderHeight() {
        return this.outerBorder.height;
    }

    public int getOuterRightPos() {
        return this.gridElementSize.width - this.getOuterRightBorderWidth();
    }

    public int getOuterDownPos() {
        return this.gridElementSize.height - this.getOuterDownBorderHeight();
    }

    public int getOuterHorizontalSum() {
        return this.getOuterLeftPos() + this.getOuterRightBorderWidth();
    }

    public int getOuterVerticalSum() {
        return this.getOuterUpPos() + this.getOuterDownBorderHeight();
    }

    public boolean hasHorizontalDrawspace() {
        return this.gridElementSize.width > this.getOuterHorizontalSum();
    }

    public boolean hasVerticalDrawspace() {
        return this.gridElementSize.width > this.getOuterHorizontalSum();
    }

    public void draw(DrawHandler drawHandler) {
        drawHandler.setBackgroundColor(ColorOwn.TRANSPARENT);
        drawHandler.setForegroundColor(ColorOwn.RED.transparency(ColorOwn.Transparency.BACKGROUND));
        drawHandler.drawRectangle(this.getOuterLeftPos(), this.getOuterUpPos(), this.getOuterRightPos() - this.getOuterLeftPos() - 1, this.getOuterDownPos() - this.getOuterUpPos());
        drawHandler.setForegroundColor(ColorOwn.BLUE);
        drawHandler.drawRectangle(this.getInnerLeftPos(), this.getInnerUpPos(), this.getInnerRightPos() - this.getInnerLeftPos(), this.getInnerDownPos() - this.getInnerUpPos());
    }
}

