/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.relation.helper;

import com.baselet.control.SharedUtils;
import com.baselet.control.basics.geom.Point;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.element.relation.helper.RelationPoint;
import com.baselet.element.relation.helper.RelationPointList;
import com.baselet.element.sticking.PointDoubleIndexed;

public class RelationPointHandlerUtils {
    static Rectangle calculateRelationRectangleBasedOnPoints(PointDouble pointDouble, int n, RelationPointList relationPointList) {
        Rectangle rectangle = relationPointList.createRectangleContainingAllPointsAndTextSpace();
        if (rectangle == null) {
            throw new RuntimeException("This relation has no points: " + relationPointList);
        }
        rectangle.setBounds(rectangle.getX() * n / 10, rectangle.getY() * n / 10, rectangle.getWidth() * n / 10, rectangle.getHeight() * n / 10);
        rectangle.setLocation(SharedUtils.realignTo(false, rectangle.getX(), false, n), SharedUtils.realignTo(false, rectangle.getY(), false, n));
        rectangle.setSize(SharedUtils.realignTo(false, rectangle.getWidth(), true, n) + n, SharedUtils.realignTo(false, rectangle.getHeight(), true, n) + n);
        rectangle.move(pointDouble.getX().intValue(), pointDouble.getY().intValue());
        return rectangle;
    }

    static PointDoubleIndexed getRelationPointContaining(Point point, RelationPointList relationPointList) {
        for (RelationPoint relationPoint : relationPointList.getPointHolders()) {
            if (!relationPoint.getSizeAbsolute().contains(point)) continue;
            return relationPoint.getPoint();
        }
        return null;
    }
}

