/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.ui.actions;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasupport.Utils;
import com.sun.tools.visualvm.core.ui.actions.MultiDataSourceAction;
import java.awt.event.ActionEvent;
import java.util.Set;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoveDataSourceAction
extends MultiDataSourceAction<DataSource> {
    private static RemoveDataSourceAction instance;

    public static synchronized RemoveDataSourceAction instance() {
        if (instance == null) {
            instance = new RemoveDataSourceAction();
        }
        return instance;
    }

    @Override
    protected void actionPerformed(Set<DataSource> dataSources, ActionEvent actionEvent) {
        for (DataSource dataSource : dataSources) {
            if (!RemoveDataSourceAction.checkRemove(dataSource)) continue;
            dataSource.getOwner().getRepository().removeDataSource(dataSource);
        }
    }

    @Override
    protected boolean isEnabled(Set<DataSource> dataSources) {
        for (DataSource dataSource : dataSources) {
            if (dataSource.supportsUserRemove()) continue;
            return false;
        }
        return Utils.areDataSourcesIndependent(dataSources);
    }

    private static boolean checkRemove(DataSource dataSource) {
        if (!dataSource.checkRemove(dataSource)) {
            return false;
        }
        Set<DataSource> repositoryDataSources = dataSource.getRepository().getDataSources();
        for (DataSource repositoryDataSource : repositoryDataSources) {
            if (repositoryDataSource.checkRemove(dataSource)) continue;
            return false;
        }
        return true;
    }

    private RemoveDataSourceAction() {
        super(DataSource.class);
        this.putValue("Name", NbBundle.getMessage(RemoveDataSourceAction.class, (String)"LBL_Remove"));
        this.putValue("ShortDescription", NbBundle.getMessage(RemoveDataSourceAction.class, (String)"DESCR_Remove"));
    }
}

