/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import org.openstreetmap.gui.jmapviewer.tilesources.AbstractOsmTileSource;

public class OsmTileSource {

    public static class CycleMap
    extends AbstractOsmTileSource {
        private static final String PATTERN = "http://%s.tile.opencyclemap.org/cycle";
        private static final String[] SERVER = new String[]{"a", "b", "c"};
        private int serverNum = 0;

        public CycleMap() {
            super("Cyclemap", PATTERN, "opencyclemap");
        }

        @Override
        public String getBaseUrl() {
            String string = String.format(this.baseUrl, SERVER[this.serverNum]);
            this.serverNum = (this.serverNum + 1) % SERVER.length;
            return string;
        }

        @Override
        public int getMaxZoom() {
            return 18;
        }
    }

    public static class Mapnik
    extends AbstractOsmTileSource {
        private static final String PATTERN = "https://%s.tile.openstreetmap.org";
        private static final String[] SERVER = new String[]{"a", "b", "c"};
        private int serverNum = 0;

        public Mapnik() {
            super("Mapnik", PATTERN, "MAPNIK");
        }

        @Override
        public String getBaseUrl() {
            String string = String.format(this.baseUrl, SERVER[this.serverNum]);
            this.serverNum = (this.serverNum + 1) % SERVER.length;
            return string;
        }
    }
}

