/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.AbstractUploadTask;
import org.openstreetmap.josm.gui.io.MaxChangesetSizeExceededPolicy;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.io.UploadStrategySpecification;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.ChangesetClosedException;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiPrimitiveGoneException;
import org.openstreetmap.josm.io.OsmServerWriter;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class UploadPrimitivesTask
extends AbstractUploadTask {
    private boolean uploadCanceled;
    private Exception lastException;
    private APIDataSet toUpload;
    private OsmServerWriter writer;
    private OsmDataLayer layer;
    private Changeset changeset;
    private Set<IPrimitive> processedPrimitives;
    private UploadStrategySpecification strategy;

    public UploadPrimitivesTask(UploadStrategySpecification uploadStrategySpecification, OsmDataLayer osmDataLayer, APIDataSet aPIDataSet, Changeset changeset) {
        super(I18n.tr("Uploading data for layer ''{0}''", osmDataLayer.getName()), false);
        CheckParameterUtil.ensureParameterNotNull(osmDataLayer, "layer");
        CheckParameterUtil.ensureParameterNotNull(uploadStrategySpecification, "strategy");
        CheckParameterUtil.ensureParameterNotNull(changeset, "changeset");
        this.toUpload = aPIDataSet;
        this.layer = osmDataLayer;
        this.changeset = changeset;
        this.strategy = uploadStrategySpecification;
        this.processedPrimitives = new HashSet<IPrimitive>();
    }

    protected MaxChangesetSizeExceededPolicy askMaxChangesetSizeExceedsPolicy() {
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Continue uploading", new Object[0]), ImageProvider.get("upload"), I18n.tr("Click to continue uploading to additional new changesets", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Go back to Upload Dialog", new Object[0]), ImageProvider.get("dialogs", "uploadproperties"), I18n.tr("Click to return to the Upload Dialog", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Abort", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to abort uploading", new Object[0]), null)};
        int n = this.toUpload.getSize() - this.processedPrimitives.size();
        String string = I18n.tr("The server reported that the current changeset was closed.<br>This is most likely because the changesets size exceeded the max. size<br>of {0} objects on the server ''{1}''.", OsmApi.getOsmApi().getCapabilities().getMaxChangesetSize(), OsmApi.getOsmApi().getBaseUrl());
        String string2 = I18n.trn("There is {0} object left to upload.", "There are {0} objects left to upload.", n, n);
        String string3 = I18n.tr("Click ''<strong>{0}</strong>'' to continue uploading to additional new changesets.<br>Click ''<strong>{1}</strong>'' to return to the upload dialog.<br>Click ''<strong>{2}</strong>'' to abort uploading and return to map editing.<br>", buttonSpecArray[0].text, buttonSpecArray[1].text, buttonSpecArray[2].text);
        String string4 = "<html>" + string + "<br><br>" + string2 + "<br><br>" + string3 + "</html>";
        int n2 = HelpAwareOptionPane.showOptionDialog(Main.parent, string4, I18n.tr("Changeset is full", new Object[0]), 2, null, buttonSpecArray, buttonSpecArray[0], HelpUtil.ht("/Action/Upload#ChangesetFull"));
        switch (n2) {
            case 0: {
                return MaxChangesetSizeExceededPolicy.AUTOMATICALLY_OPEN_NEW_CHANGESETS;
            }
            case 1: {
                return MaxChangesetSizeExceededPolicy.FILL_ONE_CHANGESET_AND_RETURN_TO_UPLOAD_DIALOG;
            }
            case 2: {
                return MaxChangesetSizeExceededPolicy.ABORT;
            }
            case -1: {
                return MaxChangesetSizeExceededPolicy.ABORT;
            }
        }
        return null;
    }

    protected void openNewChangeset() {
        ChangesetCache.getInstance().update(this.changeset);
        Changeset changeset = new Changeset();
        changeset.setKeys(this.changeset.getKeys());
        this.changeset = changeset;
    }

    protected boolean recoverFromChangesetFullException() {
        if (this.toUpload.getSize() - this.processedPrimitives.size() == 0) {
            this.strategy.setPolicy(MaxChangesetSizeExceededPolicy.ABORT);
            return false;
        }
        if (this.strategy.getPolicy() == null || this.strategy.getPolicy().equals((Object)MaxChangesetSizeExceededPolicy.ABORT)) {
            MaxChangesetSizeExceededPolicy maxChangesetSizeExceededPolicy = this.askMaxChangesetSizeExceedsPolicy();
            this.strategy.setPolicy(maxChangesetSizeExceededPolicy);
        }
        switch (this.strategy.getPolicy()) {
            case ABORT: {
                return false;
            }
            case FILL_ONE_CHANGESET_AND_RETURN_TO_UPLOAD_DIALOG: {
                return false;
            }
            case AUTOMATICALLY_OPEN_NEW_CHANGESETS: {
                this.openNewChangeset();
                this.toUpload.removeProcessed(this.processedPrimitives);
                return true;
            }
        }
        return false;
    }

    protected void recoverFromGoneOnServer(OsmApiPrimitiveGoneException osmApiPrimitiveGoneException, ProgressMonitor progressMonitor) throws OsmTransferException {
        if (!osmApiPrimitiveGoneException.isKnownPrimitive()) {
            throw osmApiPrimitiveGoneException;
        }
        OsmPrimitive osmPrimitive = this.layer.data.getPrimitiveById(osmApiPrimitiveGoneException.getPrimitiveId(), osmApiPrimitiveGoneException.getPrimitiveType());
        if (osmPrimitive == null) {
            throw osmApiPrimitiveGoneException;
        }
        if (osmPrimitive.isDeleted()) {
            String string = osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance());
            String string2 = osmPrimitive instanceof Node ? I18n.tr("Node ''{0}'' is already deleted. Skipping object in upload.", string) : (osmPrimitive instanceof Way ? I18n.tr("Way ''{0}'' is already deleted. Skipping object in upload.", string) : (osmPrimitive instanceof Relation ? I18n.tr("Relation ''{0}'' is already deleted. Skipping object in upload.", string) : I18n.tr("Object ''{0}'' is already deleted. Skipping object in upload.", string)));
            progressMonitor.appendLogMessage(string2);
            Main.warn(string2);
            this.processedPrimitives.addAll(this.writer.getProcessedPrimitives());
            this.processedPrimitives.add(osmPrimitive);
            this.toUpload.removeProcessed(this.processedPrimitives);
            return;
        }
        throw osmApiPrimitiveGoneException;
    }

    protected void cleanupAfterUpload() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                UploadPrimitivesTask.this.layer.cleanupAfterUpload(UploadPrimitivesTask.this.processedPrimitives);
                UploadPrimitivesTask.this.layer.onPostUploadToServer();
                ChangesetCache.getInstance().update(UploadPrimitivesTask.this.changeset);
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException interruptedException) {
            this.lastException = interruptedException;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.lastException = new OsmTransferException(invocationTargetException.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void realRun() {
        try {
            block33: while (true) {
                try {
                    this.getProgressMonitor().subTask(I18n.trn("Uploading {0} object...", "Uploading {0} objects...", this.toUpload.getSize(), this.toUpload.getSize()));
                    UploadPrimitivesTask uploadPrimitivesTask = this;
                    synchronized (uploadPrimitivesTask) {
                        this.writer = new OsmServerWriter();
                    }
                    this.writer.uploadOsm(this.strategy, this.toUpload.getPrimitives(), this.changeset, this.getProgressMonitor().createSubTaskMonitor(1, false));
                }
                catch (OsmTransferCanceledException osmTransferCanceledException) {
                    Main.error(osmTransferCanceledException);
                    this.uploadCanceled = true;
                }
                catch (OsmApiPrimitiveGoneException osmApiPrimitiveGoneException) {
                    this.recoverFromGoneOnServer(osmApiPrimitiveGoneException, this.getProgressMonitor());
                    continue;
                }
                catch (ChangesetClosedException changesetClosedException) {
                    this.processedPrimitives.addAll(this.writer.getProcessedPrimitives());
                    this.changeset.setOpen(false);
                    switch (changesetClosedException.getSource()) {
                        case UNSPECIFIED: {
                            throw changesetClosedException;
                        }
                        case UPDATE_CHANGESET: {
                            throw changesetClosedException;
                        }
                        case UPLOAD_DATA: {
                            if (this.recoverFromChangesetFullException()) break;
                            this.lastException = changesetClosedException;
                            break block33;
                        }
                    }
                    continue;
                }
                finally {
                    if (this.writer != null) {
                        this.processedPrimitives.addAll(this.writer.getProcessedPrimitives());
                    }
                    UploadPrimitivesTask uploadPrimitivesTask = this;
                    synchronized (uploadPrimitivesTask) {
                        this.writer = null;
                    }
                    continue;
                }
                break;
            }
            if (this.strategy.isCloseChangesetAfterUpload() && this.changeset != null && !this.changeset.isNew() && this.changeset.isOpen()) {
                OsmApi.getOsmApi().closeChangeset(this.changeset, this.progressMonitor.createSubTaskMonitor(0, false));
            }
        }
        catch (OsmTransferException osmTransferException) {
            if (this.uploadCanceled) {
                Main.info(I18n.tr("Ignoring caught exception because upload is canceled. Exception is: {0}", osmTransferException.toString()));
            }
            this.lastException = osmTransferException;
        }
        if (this.uploadCanceled && this.processedPrimitives.isEmpty()) {
            return;
        }
        this.cleanupAfterUpload();
    }

    @Override
    protected void finish() {
        if (this.uploadCanceled) {
            return;
        }
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                ChangesetCache.getInstance().update(UploadPrimitivesTask.this.changeset);
                if (UploadPrimitivesTask.this.changeset != null && UploadPrimitivesTask.this.changeset.isOpen()) {
                    UploadDialog.getUploadDialog().setSelectedChangesetForNextUpload(UploadPrimitivesTask.this.changeset);
                }
                if (UploadPrimitivesTask.this.lastException == null) {
                    new Notification("<h3>" + I18n.tr("Upload successful!", new Object[0]) + "</h3>").setIcon(ImageProvider.get("misc", "check_large")).show();
                    return;
                }
                if (UploadPrimitivesTask.this.lastException instanceof ChangesetClosedException) {
                    ChangesetClosedException changesetClosedException = (ChangesetClosedException)UploadPrimitivesTask.this.lastException;
                    if (changesetClosedException.getSource().equals((Object)ChangesetClosedException.Source.UPDATE_CHANGESET)) {
                        UploadPrimitivesTask.this.handleFailedUpload(UploadPrimitivesTask.this.lastException);
                        return;
                    }
                    if (UploadPrimitivesTask.this.strategy.getPolicy() == null) {
                        return;
                    }
                    if (changesetClosedException.getSource().equals((Object)ChangesetClosedException.Source.UPLOAD_DATA)) {
                        switch (UploadPrimitivesTask.this.strategy.getPolicy()) {
                            case ABORT: {
                                break;
                            }
                            case AUTOMATICALLY_OPEN_NEW_CHANGESETS: {
                                break;
                            }
                            case FILL_ONE_CHANGESET_AND_RETURN_TO_UPLOAD_DIALOG: {
                                UploadPrimitivesTask.this.toUpload.removeProcessed(UploadPrimitivesTask.this.processedPrimitives);
                                UploadDialog.getUploadDialog().setUploadedPrimitives(UploadPrimitivesTask.this.toUpload);
                                UploadDialog.getUploadDialog().setVisible(true);
                            }
                        }
                    } else {
                        UploadPrimitivesTask.this.handleFailedUpload(UploadPrimitivesTask.this.lastException);
                    }
                } else {
                    UploadPrimitivesTask.this.handleFailedUpload(UploadPrimitivesTask.this.lastException);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.uploadCanceled = true;
        UploadPrimitivesTask uploadPrimitivesTask = this;
        synchronized (uploadPrimitivesTask) {
            if (this.writer != null) {
                this.writer.cancel();
            }
        }
    }
}

