/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.io.session.SessionLayerExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.w3c.dom.Element;

public class GpxTracksSessionExporter
implements SessionLayerExporter {
    private GpxLayer layer;
    private JRadioButton link;
    private JRadioButton include;
    private JCheckBox export;

    public GpxTracksSessionExporter(GpxLayer gpxLayer) {
        this.layer = gpxLayer;
    }

    @Override
    public Collection<Layer> getDependencies() {
        return Collections.emptySet();
    }

    @Override
    public Component getExportPanel() {
        JComponent jComponent;
        final JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.export = new JCheckBox();
        this.export.setSelected(true);
        JLabel jLabel = new JLabel(this.layer.getName(), this.layer.getIcon(), 2);
        jLabel.setToolTipText(this.layer.getToolTipText());
        jLabel.setLabelFor(this.export);
        JLabel jLabel2 = new JLabel(I18n.tr("Data:", new Object[0]));
        this.link = new JRadioButton(I18n.tr("local file", new Object[0]));
        this.link.putClientProperty("actionname", "link");
        this.link.setToolTipText(I18n.tr("Link to a GPX file on your local disk.", new Object[0]));
        this.include = new JRadioButton(I18n.tr("include", new Object[0]));
        this.include.setToolTipText(I18n.tr("Include GPX data in the .joz session file.", new Object[0]));
        this.include.putClientProperty("actionname", "include");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.link);
        buttonGroup.add(this.include);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        final File file = this.layer.getAssociatedFile();
        if (file != null) {
            jComponent = new JosmTextField();
            ((JTextComponent)jComponent).setText(file.getPath());
            ((JTextComponent)jComponent).setEditable(false);
            jPanel3.add((Component)jComponent, GBC.std());
        } else {
            jPanel3.add((Component)new JLabel(I18n.tr("No file association", new Object[0])), GBC.eol());
        }
        jComponent = new JPanel(new GridBagLayout());
        JLabel jLabel3 = new JLabel(I18n.tr("GPX data will be included in the session file.", new Object[0]));
        jLabel3.setFont(jLabel3.getFont().deriveFont(0));
        jComponent.add((Component)jLabel3, GBC.eol().fill(2));
        final CardLayout cardLayout = new CardLayout();
        final JPanel jPanel4 = new JPanel(cardLayout);
        jPanel4.add((Component)jPanel3, "link");
        jPanel4.add((Component)jComponent, "include");
        if (file != null) {
            this.link.setSelected(true);
        } else {
            this.link.setEnabled(false);
            this.link.setToolTipText(I18n.tr("No file association", new Object[0]));
            this.include.setSelected(true);
            cardLayout.show(jPanel4, "include");
        }
        this.link.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                cardLayout.show(jPanel4, "link");
            }
        });
        this.include.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                cardLayout.show(jPanel4, "include");
            }
        });
        jPanel2.add((Component)this.export, GBC.std());
        jPanel2.add((Component)jLabel, GBC.std());
        jPanel2.add(GBC.glue(1, 0), GBC.std().fill(2));
        jPanel.add((Component)jPanel2, GBC.eol().fill(2));
        jPanel.add((Component)jLabel2, GBC.std().insets(10, 0, 0, 0));
        jPanel.add((Component)this.link, GBC.std());
        jPanel.add((Component)this.include, GBC.eol());
        jPanel.add((Component)jPanel4, GBC.eol().insets(15, 0, 3, 3));
        this.export.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    GuiHelper.setEnabledRec(jPanel, false);
                    GpxTracksSessionExporter.this.export.setEnabled(true);
                } else {
                    GuiHelper.setEnabledRec(jPanel, true);
                    GpxTracksSessionExporter.this.link.setEnabled(file != null);
                }
            }
        });
        return jPanel;
    }

    @Override
    public boolean shallExport() {
        return this.export.isSelected();
    }

    @Override
    public boolean requiresZip() {
        return this.include.isSelected();
    }

    @Override
    public Element export(SessionWriter.ExportSupport exportSupport) throws IOException {
        Element element = exportSupport.createElement("layer");
        element.setAttribute("type", "tracks");
        element.setAttribute("version", "0.1");
        Element element2 = exportSupport.createElement("file");
        element.appendChild(element2);
        if (this.requiresZip()) {
            String string = "layers/" + String.format("%02d", exportSupport.getLayerIndex()) + "/data.gpx";
            element2.appendChild(exportSupport.createTextNode(string));
            this.addDataFile(exportSupport.getOutputStreamZip(string));
        } else {
            URI uRI = this.layer.getAssociatedFile().toURI();
            URL uRL = null;
            try {
                uRL = uRI.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new IOException(malformedURLException);
            }
            element2.appendChild(exportSupport.createTextNode(uRL.toString()));
        }
        return element;
    }

    protected void addDataFile(OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        GpxWriter gpxWriter = new GpxWriter(new PrintWriter(outputStreamWriter));
        gpxWriter.write(this.layer.data);
        gpxWriter.flush();
    }
}

