/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.ValidatorHandler;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class XmlObjectParser
implements Iterable<Object> {
    public static final String lang = LanguageInfo.getLanguageCodeXML();
    private Map<String, Entry> mapping = new HashMap<String, Entry>();
    private DefaultHandler parser;
    private List<Object> queue = new LinkedList<Object>();
    private Iterator<Object> queueIterator;

    public XmlObjectParser() {
        this.parser = new Parser();
    }

    public XmlObjectParser(DefaultHandler defaultHandler) {
        this.parser = defaultHandler;
    }

    private Iterable<Object> start(Reader reader, ContentHandler contentHandler) throws SAXException, IOException {
        try {
            XMLReader xMLReader = Utils.newSafeSAXParser().getXMLReader();
            xMLReader.setContentHandler(contentHandler);
            try {
                xMLReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (SAXException sAXException) {
                Main.error("Cannot disable 'load-external-dtd' feature: " + sAXException.getMessage());
            }
            xMLReader.parse(new InputSource(reader));
            this.queueIterator = this.queue.iterator();
            return this;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }

    public Iterable<Object> start(Reader reader) throws SAXException {
        try {
            return this.start(reader, this.parser);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterable<Object> startWithValidation(Reader reader, String string, String string2) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try (InputStream inputStream = new CachedFile(string2).getInputStream();){
            Schema schema = schemaFactory.newSchema(new StreamSource(inputStream));
            ValidatorHandler validatorHandler = schema.newValidatorHandler();
            validatorHandler.setContentHandler(this.parser);
            validatorHandler.setErrorHandler(this.parser);
            AddNamespaceFilter addNamespaceFilter = new AddNamespaceFilter(string);
            addNamespaceFilter.setContentHandler(validatorHandler);
            Iterable<Object> iterable = this.start(reader, addNamespaceFilter);
            return iterable;
        }
        catch (IOException iOException) {
            throw new SAXException(I18n.tr("Failed to load XML schema.", new Object[0]), iOException);
        }
    }

    public void map(String string, Class<?> clazz) {
        this.mapping.put(string, new Entry(clazz, false, false));
    }

    public void mapOnStart(String string, Class<?> clazz) {
        this.mapping.put(string, new Entry(clazz, true, false));
    }

    public void mapBoth(String string, Class<?> clazz) {
        this.mapping.put(string, new Entry(clazz, false, true));
    }

    public Object next() {
        return this.queueIterator.next();
    }

    public boolean hasNext() {
        return this.queueIterator.hasNext();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.queue.iterator();
    }

    private static class Entry {
        private Class<?> klass;
        private boolean onStart;
        private boolean both;
        private final Map<String, Field> fields = new HashMap<String, Field>();
        private final Map<String, Method> methods = new HashMap<String, Method>();

        Entry(Class<?> clazz, boolean bl, boolean bl2) {
            this.klass = clazz;
            this.onStart = bl;
            this.both = bl2;
        }

        Field getField(String string) {
            if (this.fields.containsKey(string)) {
                return this.fields.get(string);
            }
            try {
                Field field = this.klass.getField(string);
                this.fields.put(string, field);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                this.fields.put(string, null);
                return null;
            }
        }

        Method getMethod(String string) {
            if (this.methods.containsKey(string)) {
                return this.methods.get(string);
            }
            for (Method method : this.klass.getMethods()) {
                if (!method.getName().equals(string) || method.getParameterTypes().length != 1) continue;
                this.methods.put(string, method);
                return method;
            }
            this.methods.put(string, null);
            return null;
        }
    }

    private class Parser
    extends DefaultHandler {
        private Stack<Object> current = new Stack();
        private StringBuilder characters = new StringBuilder(64);
        private Locator locator;

        private Parser() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(Exception exception) throws XmlParsingException {
            throw new XmlParsingException(exception).rememberLocation(this.locator);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (XmlObjectParser.this.mapping.containsKey(string3)) {
                Class clazz = ((Entry)XmlObjectParser.this.mapping.get(string3)).klass;
                try {
                    this.current.push(clazz.newInstance());
                }
                catch (Exception exception) {
                    this.throwException(exception);
                }
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.setValue((Entry)XmlObjectParser.this.mapping.get(string3), attributes.getQName(i), attributes.getValue(i));
                }
                if (((Entry)XmlObjectParser.this.mapping.get(string3)).onStart) {
                    this.report();
                }
                if (((Entry)XmlObjectParser.this.mapping.get(string3)).both) {
                    XmlObjectParser.this.queue.add(this.current.peek());
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (XmlObjectParser.this.mapping.containsKey(string3) && !((Entry)XmlObjectParser.this.mapping.get(string3)).onStart) {
                this.report();
            } else if (XmlObjectParser.this.mapping.containsKey(string3) && this.characters != null && !this.current.isEmpty()) {
                this.setValue((Entry)XmlObjectParser.this.mapping.get(string3), string3, this.characters.toString().trim());
                this.characters = new StringBuilder(64);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this.characters.append(cArray, n, n2);
        }

        private void report() {
            XmlObjectParser.this.queue.add(this.current.pop());
            this.characters = new StringBuilder(64);
        }

        private Object getValueForClass(Class<?> clazz, String string) {
            if (clazz == Boolean.TYPE) {
                return this.parseBoolean(string);
            }
            if (clazz == Integer.TYPE || clazz == Long.TYPE) {
                return Long.valueOf(string);
            }
            if (clazz == Float.TYPE || clazz == Double.TYPE) {
                return Double.valueOf(string);
            }
            return string;
        }

        private void setValue(Entry entry, String string, String string2) throws SAXException {
            CheckParameterUtil.ensureParameterNotNull(entry, "entry");
            if ("class".equals(string) || "default".equals(string) || "throw".equals(string) || "new".equals(string) || "null".equals(string)) {
                string = string + '_';
            }
            try {
                Object object = this.current.peek();
                Field field = entry.getField(string);
                if (field == null && string.startsWith(lang)) {
                    field = entry.getField("locale_" + string.substring(lang.length()));
                }
                if (field != null && Modifier.isPublic(field.getModifiers()) && (String.class.equals(field.getType()) || Boolean.TYPE.equals(field.getType()))) {
                    field.set(object, this.getValueForClass(field.getType(), string2));
                } else {
                    if (string.startsWith(lang)) {
                        int n = lang.length();
                        string = "set" + string.substring(n, n + 1).toUpperCase(Locale.ENGLISH) + string.substring(n + 1);
                    } else {
                        string = "set" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
                    }
                    Method method = entry.getMethod(string);
                    if (method != null) {
                        method.invoke(object, this.getValueForClass(method.getParameterTypes()[0], string2));
                    }
                }
            }
            catch (Exception exception) {
                Main.error(exception);
                this.throwException(exception);
            }
        }

        private boolean parseBoolean(String string) {
            return string != null && !"0".equals(string) && !string.startsWith("off") && !string.startsWith("false") && !string.startsWith("no");
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            this.throwException(sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.throwException(sAXParseException);
        }
    }

    private static class AddNamespaceFilter
    extends XMLFilterImpl {
        private final String namespace;

        AddNamespaceFilter(String string) {
            this.namespace = string;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("".equals(string)) {
                super.startElement(this.namespace, string2, string3, attributes);
            } else {
                super.startElement(string, string2, string3, attributes);
            }
        }
    }
}

