/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.utilities;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.utilities.ValueProfile;

public final class ExactClassValueProfile
extends ValueProfile {
    @CompilerDirectives.CompilationFinal
    protected Class<?> cachedClass;

    ExactClassValueProfile() {
    }

    @Override
    public <T> T profile(T value) {
        if (this.cachedClass != Object.class) {
            if (this.cachedClass != null && this.cachedClass.isInstance(value)) {
                return (T)this.cachedClass.cast(value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.cachedClass = this.cachedClass == null && value != null ? value.getClass() : Object.class;
        }
        return value;
    }

    public boolean isGeneric() {
        return this.cachedClass == Object.class;
    }

    public boolean isUninitialized() {
        return this.cachedClass == null;
    }

    public Class<?> getCachedClass() {
        return this.cachedClass;
    }

    public String toString() {
        return String.format("%s(%s)@%x", this.getClass().getSimpleName(), this.isUninitialized() ? "uninitialized" : (this.isGeneric() ? "generic" : this.cachedClass.getName()), this.hashCode());
    }
}

