/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.methods;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.HashSet;
import java.util.Set;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.runtime.object.ObjectGraphNode;

public class InternalMethod
implements ObjectGraphNode {
    private final SharedMethodInfo sharedMethodInfo;
    private final String name;
    private final DynamicObject declaringModule;
    private final Visibility visibility;
    private final boolean undefined;
    private final CallTarget callTarget;

    public InternalMethod(SharedMethodInfo sharedMethodInfo, String name, DynamicObject declaringModule, Visibility visibility, CallTarget callTarget) {
        this(sharedMethodInfo, name, declaringModule, visibility, false, callTarget);
    }

    private InternalMethod(SharedMethodInfo sharedMethodInfo, String name, DynamicObject declaringModule, Visibility visibility, boolean undefined, CallTarget callTarget) {
        assert (RubyGuards.isRubyModule(declaringModule));
        this.sharedMethodInfo = sharedMethodInfo;
        this.declaringModule = declaringModule;
        this.name = name;
        this.visibility = visibility;
        this.undefined = undefined;
        this.callTarget = callTarget;
    }

    public SharedMethodInfo getSharedMethodInfo() {
        return this.sharedMethodInfo;
    }

    public DynamicObject getDeclaringModule() {
        return this.declaringModule;
    }

    public String getName() {
        return this.name;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public boolean isUndefined() {
        return this.undefined;
    }

    public CallTarget getCallTarget() {
        return this.callTarget;
    }

    public InternalMethod withDeclaringModule(DynamicObject newDeclaringModule) {
        assert (RubyGuards.isRubyModule(newDeclaringModule));
        if (newDeclaringModule == this.declaringModule) {
            return this;
        }
        return new InternalMethod(this.sharedMethodInfo, this.name, newDeclaringModule, this.visibility, this.undefined, this.callTarget);
    }

    public InternalMethod withName(String newName) {
        if (newName.equals(this.name)) {
            return this;
        }
        return new InternalMethod(this.sharedMethodInfo, newName, this.declaringModule, this.visibility, this.undefined, this.callTarget);
    }

    public InternalMethod withVisibility(Visibility newVisibility) {
        if (newVisibility == this.visibility) {
            return this;
        }
        return new InternalMethod(this.sharedMethodInfo, this.name, this.declaringModule, newVisibility, this.undefined, this.callTarget);
    }

    public InternalMethod undefined() {
        return new InternalMethod(this.sharedMethodInfo, this.name, this.declaringModule, this.visibility, true, this.callTarget);
    }

    public boolean isVisibleTo(Node currentNode, DynamicObject callerClass) {
        assert (RubyGuards.isRubyClass(callerClass));
        switch (this.visibility) {
            case PUBLIC: {
                return true;
            }
            case PROTECTED: {
                for (DynamicObject ancestor : Layouts.MODULE.getFields(callerClass).ancestors()) {
                    if (ancestor != this.declaringModule && Layouts.BASIC_OBJECT.getMetaClass(ancestor) != this.declaringModule) continue;
                    return true;
                }
                return false;
            }
            case PRIVATE: {
                return false;
            }
        }
        throw new UnsupportedOperationException(this.visibility.name());
    }

    public String toString() {
        return this.sharedMethodInfo.toString();
    }

    @Override
    public Set<DynamicObject> getAdjacentObjects() {
        HashSet<DynamicObject> adjacent = new HashSet<DynamicObject>();
        if (this.declaringModule != null) {
            adjacent.add(this.declaringModule);
        }
        return adjacent;
    }
}

