/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.optimize.peephole.BranchTargetFinder;

public class GotoCommonCodeReplacer
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor {
    private static final boolean DEBUG = false;
    private final InstructionVisitor extraInstructionVisitor;
    private final BranchTargetFinder branchTargetFinder = new BranchTargetFinder();
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(true, false);

    public GotoCommonCodeReplacer(InstructionVisitor instructionVisitor) {
        this.extraInstructionVisitor = instructionVisitor;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.branchTargetFinder.visitCodeAttribute(clazz, method, codeAttribute);
        this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
        int n2;
        int n3;
        int n4;
        byte by = branchInstruction.opcode;
        if (!(by != -89 && by != -56 || this.branchTargetFinder.isBranchTarget(n) || (n4 = this.commonByteCodeCount(codeAttribute, n, n3 = n + (n2 = branchInstruction.branchOffset))) <= 0 || this.exceptionBoundary(codeAttribute, n, n3))) {
            int n5;
            for (n5 = 0; n5 <= n4; ++n5) {
                int n6 = n - n5;
                if (!this.branchTargetFinder.isInstruction(n6)) continue;
                this.codeAttributeEditor.clearModifications(n6);
                this.codeAttributeEditor.deleteInstruction(n6);
            }
            n5 = n2 - n4;
            if (n5 != branchInstruction.length(n)) {
                Instruction instruction = new BranchInstruction(by, n5).shrink();
                this.codeAttributeEditor.replaceInstruction(n, instruction);
            }
            if (this.extraInstructionVisitor != null) {
                this.extraInstructionVisitor.visitBranchInstruction(clazz, method, codeAttribute, n, branchInstruction);
            }
        }
    }

    private int commonByteCodeCount(CodeAttribute codeAttribute, int n, int n2) {
        int n3;
        int n4;
        byte[] byArray = codeAttribute.code;
        int n5 = 0;
        for (int i = 1; i <= n && i <= n2 && n2 - i != n && byArray[n4 = n - i] == byArray[n3 = n2 - i] && !(this.branchTargetFinder.isInstruction(n4) ^ this.branchTargetFinder.isInstruction(n3)); ++i) {
            if (!this.branchTargetFinder.isInstruction(n4) || !this.branchTargetFinder.isInstruction(n3)) continue;
            if (this.branchTargetFinder.isBranchOrigin(n4) || this.branchTargetFinder.isBranchTarget(n4) || this.branchTargetFinder.isExceptionStart(n4) || this.branchTargetFinder.isExceptionEnd(n4) || this.branchTargetFinder.isInitializer(n4) || this.branchTargetFinder.isExceptionStart(n3) || this.branchTargetFinder.isExceptionEnd(n3) || this.isPop(byArray[n4])) break;
            if (this.branchTargetFinder.isBranchTarget(n3)) {
                n5 = i;
            }
            if (this.branchTargetFinder.isBranchTarget(n4)) break;
        }
        return n5;
    }

    private boolean isPop(byte by) {
        return by == 87 || by == 88 || by == -66;
    }

    private boolean exceptionBoundary(CodeAttribute codeAttribute, int n, int n2) {
        int n3;
        if (n2 < n) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        for (n3 = n; n3 <= n2; ++n3) {
            if (!this.branchTargetFinder.isExceptionStart(n3) && !this.branchTargetFinder.isExceptionEnd(n3)) continue;
            return true;
        }
        return false;
    }
}

