/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.inject.Guice;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.InjectorImpl;
import org.elasticsearch.common.inject.Injectors;
import org.elasticsearch.common.inject.Module;

public class ModulesBuilder
implements Iterable<Module> {
    private final List<Module> modules = new ArrayList<Module>();

    public ModulesBuilder add(Module ... newModules) {
        for (Module module : newModules) {
            this.modules.add(module);
        }
        return this;
    }

    @Override
    public Iterator<Module> iterator() {
        return this.modules.iterator();
    }

    public Injector createInjector() {
        Injector injector = Guice.createInjector(this.modules);
        Injectors.cleanCaches(injector);
        ((InjectorImpl)injector).readOnlyAllSingletons();
        return injector;
    }

    public Injector createChildInjector(Injector injector) {
        Injector childInjector = injector.createChildInjector(this.modules);
        Injectors.cleanCaches(childInjector);
        ((InjectorImpl)childInjector).readOnlyAllSingletons();
        return childInjector;
    }
}

