/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.discovery.InitialStateDiscoveryListener;

public class DiscoveryService
extends AbstractLifecycleComponent<DiscoveryService> {
    public static final String SETTING_INITIAL_STATE_TIMEOUT = "discovery.initial_state_timeout";
    public static final String SETTING_DISCOVERY_SEED = "discovery.id.seed";
    private final TimeValue initialStateTimeout;
    private final Discovery discovery;
    private InitialStateListener initialStateListener;
    private final DiscoverySettings discoverySettings;

    @Inject
    public DiscoveryService(Settings settings, DiscoverySettings discoverySettings, Discovery discovery) {
        super(settings);
        this.discoverySettings = discoverySettings;
        this.discovery = discovery;
        this.initialStateTimeout = settings.getAsTime(SETTING_INITIAL_STATE_TIMEOUT, TimeValue.timeValueSeconds(30L));
    }

    public ClusterBlock getNoMasterBlock() {
        return this.discoverySettings.getNoMasterBlock();
    }

    @Override
    protected void doStart() {
        this.initialStateListener = new InitialStateListener();
        this.discovery.addListener(this.initialStateListener);
        this.discovery.start();
        this.logger.info(this.discovery.nodeDescription(), new Object[0]);
    }

    public void waitForInitialState() {
        try {
            if (!this.initialStateListener.waitForInitialState(this.initialStateTimeout)) {
                this.logger.warn("waited for {} and no initial state was set by the discovery", this.initialStateTimeout);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ElasticsearchTimeoutException("Interrupted while waiting for initial discovery state", new Object[0]);
        }
    }

    @Override
    protected void doStop() {
        if (this.initialStateListener != null) {
            this.discovery.removeListener(this.initialStateListener);
        }
        this.discovery.stop();
    }

    @Override
    protected void doClose() {
        this.discovery.close();
    }

    public DiscoveryNode localNode() {
        return this.discovery.localNode();
    }

    public String nodeDescription() {
        return this.discovery.nodeDescription();
    }

    public void publish(ClusterChangedEvent clusterChangedEvent, Discovery.AckListener ackListener) {
        if (this.lifecycle.started()) {
            this.discovery.publish(clusterChangedEvent, ackListener);
        }
    }

    public static String generateNodeId(Settings settings) {
        String seed = settings.get(SETTING_DISCOVERY_SEED);
        if (seed != null) {
            return Strings.randomBase64UUID(new Random(Long.parseLong(seed)));
        }
        return Strings.randomBase64UUID();
    }

    private static class InitialStateListener
    implements InitialStateDiscoveryListener {
        private final CountDownLatch latch = new CountDownLatch(1);
        private volatile boolean initialStateReceived;

        private InitialStateListener() {
        }

        @Override
        public void initialStateProcessed() {
            this.initialStateReceived = true;
            this.latch.countDown();
        }

        public boolean waitForInitialState(TimeValue timeValue) throws InterruptedException {
            if (timeValue.millis() > 0L) {
                this.latch.await(timeValue.millis(), TimeUnit.MILLISECONDS);
            }
            return this.initialStateReceived;
        }
    }
}

