/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.ExtensionPoint;
import org.elasticsearch.gateway.DanglingIndicesState;
import org.elasticsearch.gateway.Gateway;
import org.elasticsearch.gateway.GatewayMetaState;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.gateway.LocalAllocateDangledIndices;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.gateway.TransportNodesListGatewayMetaState;
import org.elasticsearch.gateway.TransportNodesListGatewayStartedShards;

public class GatewayModule
extends AbstractModule {
    public static final String GATEWAY_TYPE_KEY = "gateway.type";
    private final ExtensionPoint.SelectedType<Gateway> gatewayTypes = new ExtensionPoint.SelectedType<Gateway>("gateway", Gateway.class);
    private final Settings settings;

    public GatewayModule(Settings settings) {
        this.settings = settings;
        this.registerGatewayType("default", Gateway.class);
    }

    public void registerGatewayType(String type, Class<? extends Gateway> clazz) {
        this.gatewayTypes.registerExtension(type, clazz);
    }

    @Override
    protected void configure() {
        this.bind(MetaStateService.class).asEagerSingleton();
        this.bind(DanglingIndicesState.class).asEagerSingleton();
        this.bind(GatewayService.class).asEagerSingleton();
        this.gatewayTypes.bindType(this.binder(), this.settings, GATEWAY_TYPE_KEY, "default");
        this.bind(TransportNodesListGatewayMetaState.class).asEagerSingleton();
        this.bind(GatewayMetaState.class).asEagerSingleton();
        this.bind(TransportNodesListGatewayStartedShards.class).asEagerSingleton();
        this.bind(LocalAllocateDangledIndices.class).asEagerSingleton();
    }
}

