/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.bitset;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardUtils;
import org.elasticsearch.indices.IndicesWarmer;
import org.elasticsearch.threadpool.ThreadPool;

public class BitsetFilterCache
extends AbstractIndexComponent
implements LeafReader.CoreClosedListener,
RemovalListener<Object, Cache<Query, Value>>,
Closeable {
    public static final String LOAD_RANDOM_ACCESS_FILTERS_EAGERLY = "index.load_fixed_bitset_filters_eagerly";
    private static final Listener DEFAULT_NOOP_LISTENER = new Listener(){

        @Override
        public void onCache(ShardId shardId, Accountable accountable) {
        }

        @Override
        public void onRemoval(ShardId shardId, Accountable accountable) {
        }
    };
    private final boolean loadRandomAccessFiltersEagerly;
    private final Cache<Object, Cache<Query, Value>> loadedFilters;
    private volatile Listener listener = DEFAULT_NOOP_LISTENER;
    private final BitSetProducerWarmer warmer;
    private IndicesWarmer indicesWarmer;

    @Inject
    public BitsetFilterCache(Index index, IndexSettingsService indexSettingsService) {
        this(index, indexSettingsService.getSettings());
    }

    BitsetFilterCache(Index index, Settings indexSettings) {
        super(index, indexSettings);
        this.loadRandomAccessFiltersEagerly = indexSettings.getAsBoolean(LOAD_RANDOM_ACCESS_FILTERS_EAGERLY, (Boolean)true);
        this.loadedFilters = CacheBuilder.newBuilder().removalListener((RemovalListener)this).build();
        this.warmer = new BitSetProducerWarmer();
    }

    @Inject(optional=true)
    public void setIndicesWarmer(IndicesWarmer indicesWarmer) {
        this.indicesWarmer = indicesWarmer;
        indicesWarmer.addListener(this.warmer);
    }

    public void setListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.listener != DEFAULT_NOOP_LISTENER) {
            throw new IllegalStateException("can't set listener more than once");
        }
        this.listener = listener;
    }

    public BitSetProducer getBitSetProducer(Query query) {
        return new QueryWrapperBitSetProducer(query);
    }

    public void onClose(Object ownerCoreCacheKey) {
        this.loadedFilters.invalidate(ownerCoreCacheKey);
    }

    @Override
    public void close() {
        if (this.indicesWarmer != null) {
            this.indicesWarmer.removeListener(this.warmer);
        }
        this.clear("close");
    }

    public void clear(String reason) {
        this.logger.debug("clearing all bitsets because [{}]", reason);
        this.loadedFilters.invalidateAll();
    }

    private BitSet getAndLoadIfNotPresent(final Query query, final LeafReaderContext context) throws IOException, ExecutionException {
        Object coreCacheReader = context.reader().getCoreCacheKey();
        final ShardId shardId = ShardUtils.extractShardId(context.reader());
        Cache filterToFbs = (Cache)this.loadedFilters.get(coreCacheReader, (Callable)new Callable<Cache<Query, Value>>(){

            @Override
            public Cache<Query, Value> call() throws Exception {
                context.reader().addCoreClosedListener((LeafReader.CoreClosedListener)BitsetFilterCache.this);
                return CacheBuilder.newBuilder().build();
            }
        });
        return ((Value)filterToFbs.get((Object)query, (Callable)new Callable<Value>(){

            @Override
            public Value call() throws Exception {
                IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)context);
                IndexSearcher searcher = new IndexSearcher(topLevelContext);
                searcher.setQueryCache(null);
                Weight weight = searcher.createNormalizedWeight(query, false);
                Scorer it = weight.scorer(context);
                BitSet bitSet = it == null ? null : BitSet.of((DocIdSetIterator)it, (int)context.reader().maxDoc());
                Value value = new Value(bitSet, shardId);
                BitsetFilterCache.this.listener.onCache(shardId, (Accountable)value.bitset);
                return value;
            }
        })).bitset;
    }

    public void onRemoval(RemovalNotification<Object, Cache<Query, Value>> notification) {
        Object key = notification.getKey();
        if (key == null) {
            return;
        }
        Cache valueCache = (Cache)notification.getValue();
        if (valueCache == null) {
            return;
        }
        for (Value value : valueCache.asMap().values()) {
            this.listener.onRemoval(value.shardId, (Accountable)value.bitset);
        }
    }

    Cache<Object, Cache<Query, Value>> getLoadedFilters() {
        return this.loadedFilters;
    }

    public static interface Listener {
        public void onCache(ShardId var1, Accountable var2);

        public void onRemoval(ShardId var1, Accountable var2);
    }

    final class BitSetProducerWarmer
    extends IndicesWarmer.Listener {
        BitSetProducerWarmer() {
        }

        @Override
        public IndicesWarmer.TerminationHandle warmNewReaders(final IndexShard indexShard, IndexMetaData indexMetaData, IndicesWarmer.WarmerContext context, ThreadPool threadPool) {
            if (!BitsetFilterCache.this.loadRandomAccessFiltersEagerly) {
                return IndicesWarmer.TerminationHandle.NO_WAIT;
            }
            boolean hasNested = false;
            HashSet<Filter> warmUp = new HashSet<Filter>();
            MapperService mapperService = indexShard.mapperService();
            for (DocumentMapper docMapper : mapperService.docMappers(false)) {
                if (!docMapper.hasNestedObjects()) continue;
                hasNested = true;
                for (ObjectMapper objectMapper : docMapper.objectMappers().values()) {
                    ObjectMapper parentObjectMapper;
                    if (!objectMapper.nested().isNested() || (parentObjectMapper = docMapper.findParentObjectMapper(objectMapper)) == null || !parentObjectMapper.nested().isNested()) continue;
                    warmUp.add(parentObjectMapper.nestedTypeFilter());
                }
            }
            if (hasNested) {
                warmUp.add(Queries.newNonNestedFilter());
            }
            Executor executor = threadPool.executor(this.executor());
            final CountDownLatch latch = new CountDownLatch(context.searcher().reader().leaves().size() * warmUp.size());
            for (final LeafReaderContext ctx : context.searcher().reader().leaves()) {
                for (final Query query : warmUp) {
                    executor.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                long start = System.nanoTime();
                                BitsetFilterCache.this.getAndLoadIfNotPresent(query, ctx);
                                if (indexShard.warmerService().logger().isTraceEnabled()) {
                                    indexShard.warmerService().logger().trace("warmed bitset for [{}], took [{}]", query, TimeValue.timeValueNanos(System.nanoTime() - start));
                                }
                            }
                            catch (Throwable t) {
                                indexShard.warmerService().logger().warn("failed to load bitset for [{}]", t, query);
                            }
                            finally {
                                latch.countDown();
                            }
                        }
                    });
                }
            }
            return new IndicesWarmer.TerminationHandle(){

                @Override
                public void awaitTermination() throws InterruptedException {
                    latch.await();
                }
            };
        }

        @Override
        public IndicesWarmer.TerminationHandle warmTopReader(IndexShard indexShard, IndexMetaData indexMetaData, IndicesWarmer.WarmerContext context, ThreadPool threadPool) {
            return IndicesWarmer.TerminationHandle.NO_WAIT;
        }
    }

    final class QueryWrapperBitSetProducer
    implements BitSetProducer {
        final Query query;

        QueryWrapperBitSetProducer(Query query) {
            this.query = Objects.requireNonNull(query);
        }

        public BitSet getBitSet(LeafReaderContext context) throws IOException {
            try {
                return BitsetFilterCache.this.getAndLoadIfNotPresent(this.query, context);
            }
            catch (ExecutionException e) {
                throw ExceptionsHelper.convertToElastic(e);
            }
        }

        public String toString() {
            return "random_access(" + this.query + ")";
        }

        public boolean equals(Object o) {
            if (!(o instanceof QueryWrapperBitSetProducer)) {
                return false;
            }
            return this.query.equals((Object)((QueryWrapperBitSetProducer)o).query);
        }

        public int hashCode() {
            return 31 * this.getClass().hashCode() + this.query.hashCode();
        }
    }

    public static final class Value {
        final BitSet bitset;
        final ShardId shardId;

        public Value(BitSet bitset, ShardId shardId) {
            this.bitset = bitset;
            this.shardId = shardId;
        }
    }
}

