/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.deletionpolicy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.name.Named;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.deletionpolicy.AbstractESDeletionPolicy;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommits;
import org.elasticsearch.index.shard.IndexShardComponent;

public class SnapshotDeletionPolicy
extends AbstractESDeletionPolicy {
    private final IndexDeletionPolicy primary;
    private final ConcurrentMap<Long, SnapshotHolder> snapshots = ConcurrentCollections.newConcurrentMap();
    private volatile List<SnapshotIndexCommit> commits;
    private final Object mutex = new Object();
    private SnapshotIndexCommit lastCommit;

    @Inject
    public SnapshotDeletionPolicy(@Named(value="actual") IndexDeletionPolicy primary) {
        super(((IndexShardComponent)primary).shardId(), ((IndexShardComponent)primary).indexSettings());
        this.primary = primary;
    }

    public void onInit(List<? extends IndexCommit> commits) throws IOException {
        if (!commits.isEmpty()) {
            this.onCommit(commits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommit(List<? extends IndexCommit> commits) throws IOException {
        assert (!commits.isEmpty()) : "Commits must not be empty";
        Object object = this.mutex;
        synchronized (object) {
            List<SnapshotIndexCommit> snapshotCommits = this.wrapCommits(commits);
            this.primary.onCommit(snapshotCommits);
            Iterator it = this.snapshots.values().iterator();
            while (it.hasNext()) {
                SnapshotHolder holder = (SnapshotHolder)it.next();
                if (holder.counter > 0) continue;
                it.remove();
            }
            ArrayList<SnapshotIndexCommit> newCommits = new ArrayList<SnapshotIndexCommit>();
            for (SnapshotIndexCommit commit : snapshotCommits) {
                if (commit.isDeleted()) continue;
                newCommits.add(commit);
            }
            this.commits = newCommits;
            this.lastCommit = (SnapshotIndexCommit)newCommits.get(newCommits.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnapshotIndexCommits snapshots() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.snapshots == null) {
                throw new IllegalStateException("Snapshot deletion policy has not been init yet...");
            }
            ArrayList<SnapshotIndexCommit> result = new ArrayList<SnapshotIndexCommit>(this.commits.size());
            for (SnapshotIndexCommit commit : this.commits) {
                result.add(this.snapshot(commit));
            }
            return new SnapshotIndexCommits(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnapshotIndexCommit snapshot() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.lastCommit == null) {
                throw new IllegalStateException("Snapshot deletion policy has not been init yet...");
            }
            return this.snapshot(this.lastCommit);
        }
    }

    public IndexDeletionPolicy clone() {
        return this;
    }

    private SnapshotIndexCommit snapshot(SnapshotIndexCommit commit) throws IOException {
        SnapshotHolder snapshotHolder = (SnapshotHolder)this.snapshots.get(commit.getGeneration());
        if (snapshotHolder == null) {
            snapshotHolder = new SnapshotHolder(0);
            this.snapshots.put(commit.getGeneration(), snapshotHolder);
        }
        ++snapshotHolder.counter;
        return new OneTimeReleaseSnapshotIndexCommit(this, commit);
    }

    boolean isHeld(long version) {
        SnapshotHolder holder = (SnapshotHolder)this.snapshots.get(version);
        return holder != null && holder.counter > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean close(long version) {
        Object object = this.mutex;
        synchronized (object) {
            SnapshotHolder holder = (SnapshotHolder)this.snapshots.get(version);
            if (holder == null) {
                return false;
            }
            if (holder.counter <= 0) {
                this.snapshots.remove(version);
                return false;
            }
            if (--holder.counter == 0) {
                this.snapshots.remove(version);
            }
            return true;
        }
    }

    private List<SnapshotIndexCommit> wrapCommits(List<? extends IndexCommit> commits) throws IOException {
        int count = commits.size();
        ArrayList<SnapshotIndexCommit> snapshotCommits = new ArrayList<SnapshotIndexCommit>(count);
        for (int i = 0; i < count; ++i) {
            snapshotCommits.add(new SnapshotIndexCommit(this, commits.get(i)));
        }
        return snapshotCommits;
    }

    private static class SnapshotHolder {
        int counter;

        private SnapshotHolder(int counter) {
            this.counter = counter;
        }
    }

    private static class OneTimeReleaseSnapshotIndexCommit
    extends SnapshotIndexCommit {
        private volatile boolean released = false;

        OneTimeReleaseSnapshotIndexCommit(SnapshotDeletionPolicy deletionPolicy, IndexCommit cp) throws IOException {
            super(deletionPolicy, cp);
        }

        @Override
        public void close() {
            if (this.released) {
                return;
            }
            this.released = true;
            ((SnapshotIndexCommit)this.delegate).close();
        }
    }
}

