/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Base64;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.uid.Versions;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.deletionpolicy.SnapshotDeletionPolicy;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.EngineSearcher;
import org.elasticsearch.index.engine.FlushNotAllowedEngineException;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;

public abstract class Engine
implements Closeable {
    public static final String SYNC_COMMIT_ID = "sync_id";
    protected final ShardId shardId;
    protected final ESLogger logger;
    protected final EngineConfig engineConfig;
    protected final Store store;
    protected final AtomicBoolean isClosed = new AtomicBoolean(false);
    protected final FailedEngineListener failedEngineListener;
    protected final SnapshotDeletionPolicy deletionPolicy;
    protected final ReentrantLock failEngineLock = new ReentrantLock();
    protected final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    protected final ReleasableLock readLock = new ReleasableLock(this.rwl.readLock());
    protected final ReleasableLock writeLock = new ReleasableLock(this.rwl.writeLock());
    protected volatile Throwable failedEngine = null;

    protected Engine(EngineConfig engineConfig) {
        Preconditions.checkNotNull((Object)engineConfig.getStore(), (Object)"Store must be provided to the engine");
        Preconditions.checkNotNull((Object)engineConfig.getDeletionPolicy(), (Object)"Snapshot deletion policy must be provided to the engine");
        this.engineConfig = engineConfig;
        this.shardId = engineConfig.getShardId();
        this.store = engineConfig.getStore();
        this.logger = Loggers.getLogger(Engine.class, engineConfig.getIndexSettings(), engineConfig.getShardId(), new String[0]);
        this.failedEngineListener = engineConfig.getFailedEngineListener();
        this.deletionPolicy = engineConfig.getDeletionPolicy();
    }

    protected static long guardedRamBytesUsed(Accountable a) {
        if (a == null) {
            return 0L;
        }
        return a.ramBytesUsed();
    }

    protected static SegmentReader segmentReader(LeafReader reader) {
        if (reader instanceof SegmentReader) {
            return (SegmentReader)reader;
        }
        if (reader instanceof FilterLeafReader) {
            FilterLeafReader fReader = (FilterLeafReader)reader;
            return Engine.segmentReader(FilterLeafReader.unwrap((LeafReader)fReader));
        }
        throw new IllegalStateException("Can not extract segment reader from given index reader [" + reader + "]");
    }

    protected static boolean isMergedSegment(LeafReader reader) {
        Map diagnostics = Engine.segmentReader((LeafReader)reader).getSegmentInfo().info.getDiagnostics();
        String source = (String)diagnostics.get("source");
        assert (Arrays.asList("addIndexes(CodecReader...)", "flush", "merge").contains(source)) : "Unknown source " + source;
        return "merge".equals(source);
    }

    protected Searcher newSearcher(String source, IndexSearcher searcher, SearcherManager manager) {
        return new EngineSearcher(source, searcher, manager, this.store, this.logger);
    }

    public final EngineConfig config() {
        return this.engineConfig;
    }

    protected abstract SegmentInfos getLastCommittedSegmentInfos();

    public MergeStats getMergeStats() {
        return new MergeStats();
    }

    public abstract void create(Create var1) throws EngineException;

    public abstract boolean index(Index var1) throws EngineException;

    public abstract void delete(Delete var1) throws EngineException;

    @Deprecated
    public abstract void delete(DeleteByQuery var1) throws EngineException;

    public abstract SyncedFlushResult syncFlush(String var1, CommitId var2) throws EngineException;

    protected final GetResult getFromSearcher(Get get) throws EngineException {
        Versions.DocIdAndVersion docIdAndVersion;
        Searcher searcher = this.acquireSearcher("get");
        try {
            docIdAndVersion = Versions.loadDocIdAndVersion(searcher.reader(), get.uid());
        }
        catch (Throwable e) {
            Releasables.closeWhileHandlingException(searcher);
            throw new EngineException(this.shardId, "Couldn't resolve version", e);
        }
        if (docIdAndVersion != null && get.versionType().isVersionConflictForReads(docIdAndVersion.version, get.version())) {
            Releasables.close(searcher);
            Uid uid = Uid.createUid(get.uid().text());
            throw new VersionConflictEngineException(this.shardId, uid.type(), uid.id(), docIdAndVersion.version, get.version());
        }
        if (docIdAndVersion != null) {
            return new GetResult(searcher, docIdAndVersion);
        }
        Releasables.close(searcher);
        return GetResult.NOT_EXISTS;
    }

    public abstract GetResult get(Get var1) throws EngineException;

    public final Searcher acquireSearcher(String source) throws EngineException {
        return this.acquireSearcher(source, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Searcher acquireSearcher(String source, boolean maybeWrap) throws EngineException {
        boolean success = false;
        this.store.incRef();
        try {
            Searcher searcher;
            block11: {
                SearcherManager manager = this.getSearcherManager();
                IndexSearcher searcher2 = (IndexSearcher)manager.acquire();
                try {
                    Searcher retVal = this.newSearcher(source, searcher2, manager);
                    Searcher wrappedSearcher = maybeWrap ? this.config().getWrappingService().wrap(this.engineConfig, retVal) : retVal;
                    success = true;
                    searcher = wrappedSearcher;
                    if (success) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (!success) {
                            manager.release((Object)searcher2);
                        }
                        throw throwable;
                    }
                    catch (EngineClosedException ex) {
                        throw ex;
                    }
                    catch (Throwable ex) {
                        this.ensureOpen();
                        this.logger.error("failed to acquire searcher, source {}", ex, source);
                        throw new EngineException(this.shardId, "failed to acquire searcher, source " + source, ex);
                    }
                }
                manager.release((Object)searcher2);
            }
            return searcher;
        }
        finally {
            if (!success) {
                this.store.decRef();
            }
        }
    }

    public abstract Translog getTranslog();

    protected void ensureOpen() {
        if (this.isClosed.get()) {
            throw new EngineClosedException(this.shardId, this.failedEngine);
        }
    }

    public CommitStats commitStats() {
        return new CommitStats(this.getLastCommittedSegmentInfos());
    }

    protected static SegmentInfos readLastCommittedSegmentInfos(SearcherManager sm, Store store) throws IOException {
        IndexSearcher searcher = (IndexSearcher)sm.acquire();
        try {
            IndexCommit latestCommit = ((DirectoryReader)searcher.getIndexReader()).getIndexCommit();
            SegmentInfos segmentInfos = Lucene.readSegmentInfos(latestCommit);
            return segmentInfos;
        }
        catch (IOException e) {
            try {
                SegmentInfos segmentInfos = store.readLastCommittedSegmentsInfo();
                return segmentInfos;
            }
            catch (IOException e2) {
                e2.addSuppressed(e);
                throw e2;
            }
        }
        finally {
            sm.release((Object)searcher);
        }
    }

    public final SegmentsStats segmentsStats() {
        this.ensureOpen();
        try (Searcher searcher = this.acquireSearcher("segments_stats", false);){
            SegmentsStats stats = new SegmentsStats();
            for (LeafReaderContext reader : searcher.reader().leaves()) {
                SegmentReader segmentReader = Engine.segmentReader(reader.reader());
                stats.add(1L, segmentReader.ramBytesUsed());
                stats.addTermsMemoryInBytes(Engine.guardedRamBytesUsed((Accountable)segmentReader.getPostingsReader()));
                stats.addStoredFieldsMemoryInBytes(Engine.guardedRamBytesUsed((Accountable)segmentReader.getFieldsReader()));
                stats.addTermVectorsMemoryInBytes(Engine.guardedRamBytesUsed((Accountable)segmentReader.getTermVectorsReader()));
                stats.addNormsMemoryInBytes(Engine.guardedRamBytesUsed((Accountable)segmentReader.getNormsReader()));
                stats.addDocValuesMemoryInBytes(Engine.guardedRamBytesUsed((Accountable)segmentReader.getDocValuesReader()));
            }
            this.writerSegmentStats(stats);
            SegmentsStats segmentsStats = stats;
            return segmentsStats;
        }
    }

    protected void writerSegmentStats(SegmentsStats stats) {
        stats.addVersionMapMemoryInBytes(0L);
        stats.addIndexWriterMemoryInBytes(0L);
        stats.addIndexWriterMaxMemoryInBytes(0L);
    }

    public abstract long indexWriterRAMBytesUsed();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Segment[] getSegmentInfo(SegmentInfos lastCommittedSegmentInfos, boolean verbose) {
        Segment segment;
        this.ensureOpen();
        HashMap<String, Segment> segments = new HashMap<String, Segment>();
        try (Searcher searcher = this.acquireSearcher("segments", false);){
            for (LeafReaderContext reader : searcher.reader().leaves()) {
                SegmentCommitInfo info = Engine.segmentReader(reader.reader()).getSegmentInfo();
                assert (!segments.containsKey(info.info.name));
                segment = new Segment(info.info.name);
                segment.search = true;
                segment.docCount = reader.reader().numDocs();
                segment.delDocCount = reader.reader().numDeletedDocs();
                segment.version = info.info.getVersion();
                segment.compound = info.info.getUseCompoundFile();
                try {
                    segment.sizeInBytes = info.sizeInBytes();
                }
                catch (IOException e) {
                    this.logger.trace("failed to get size for [{}]", e, info.info.name);
                }
                SegmentReader segmentReader = Engine.segmentReader(reader.reader());
                segment.memoryInBytes = segmentReader.ramBytesUsed();
                if (verbose) {
                    segment.ramTree = Accountables.namedAccountable((String)"root", (Accountable)segmentReader);
                }
                segments.put(info.info.name, segment);
            }
        }
        if (lastCommittedSegmentInfos != null) {
            SegmentInfos infos = lastCommittedSegmentInfos;
            for (SegmentCommitInfo info : infos) {
                segment = (Segment)segments.get(info.info.name);
                if (segment == null) {
                    segment = new Segment(info.info.name);
                    segment.search = false;
                    segment.committed = true;
                    segment.docCount = info.info.maxDoc();
                    segment.delDocCount = info.getDelCount();
                    segment.version = info.info.getVersion();
                    segment.compound = info.info.getUseCompoundFile();
                    try {
                        segment.sizeInBytes = info.sizeInBytes();
                    }
                    catch (IOException e) {
                        this.logger.trace("failed to get size for [{}]", e, info.info.name);
                    }
                    segments.put(info.info.name, segment);
                    continue;
                }
                segment.committed = true;
            }
        }
        Segment[] segmentsArr = segments.values().toArray(new Segment[segments.values().size()]);
        Arrays.sort(segmentsArr, new Comparator<Segment>(){

            @Override
            public int compare(Segment o1, Segment o2) {
                return (int)(o1.getGeneration() - o2.getGeneration());
            }
        });
        return segmentsArr;
    }

    public abstract List<Segment> segments(boolean var1);

    public final boolean refreshNeeded() {
        if (this.store.tryIncRef()) {
            try {
                boolean bl = !this.getSearcherManager().isSearcherCurrent();
                return bl;
            }
            catch (IOException e) {
                this.logger.error("failed to access searcher manager", e, new Object[0]);
                this.failEngine("failed to access searcher manager", e);
                throw new EngineException(this.shardId, "failed to access searcher manager", e);
            }
            finally {
                this.store.decRef();
            }
        }
        return false;
    }

    public abstract void refresh(String var1) throws EngineException;

    public abstract CommitId flush(boolean var1, boolean var2) throws EngineException;

    public abstract CommitId flush() throws EngineException;

    public void forceMerge(boolean flush) throws IOException {
        this.forceMerge(flush, 1, false, false, false);
    }

    public abstract void forceMerge(boolean var1, int var2, boolean var3, boolean var4, boolean var5) throws EngineException, IOException;

    public abstract SnapshotIndexCommit snapshotIndex(boolean var1) throws EngineException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failEngine(String reason, @Nullable Throwable failure) {
        if (this.failEngineLock.tryLock()) {
            this.store.incRef();
            try {
                block18: {
                    try {
                        this.closeNoLock("engine failed on: [" + reason + "]");
                        if (this.failedEngine == null) break block18;
                    }
                    catch (Throwable throwable) {
                        if (this.failedEngine != null) {
                            this.logger.debug("tried to fail engine but engine is already failed. ignoring. [{}]", reason, failure);
                            return;
                        }
                        this.logger.warn("failed engine [{}]", failure, reason);
                        Throwable throwable2 = this.failedEngine = failure != null ? failure : new IllegalStateException(reason);
                        if (Lucene.isCorruptionException(failure)) {
                            try {
                                this.store.markStoreCorrupted(new IOException("failed engine (reason: [" + reason + "])", ExceptionsHelper.unwrapCorruption(failure)));
                            }
                            catch (IOException e) {
                                this.logger.warn("Couldn't mark store corrupted", e, new Object[0]);
                            }
                        }
                        this.failedEngineListener.onFailedEngine(this.shardId, reason, failure);
                        throw throwable;
                    }
                    this.logger.debug("tried to fail engine but engine is already failed. ignoring. [{}]", reason, failure);
                    return;
                }
                this.logger.warn("failed engine [{}]", failure, reason);
                Throwable throwable = this.failedEngine = failure != null ? failure : new IllegalStateException(reason);
                if (Lucene.isCorruptionException(failure)) {
                    try {
                        this.store.markStoreCorrupted(new IOException("failed engine (reason: [" + reason + "])", ExceptionsHelper.unwrapCorruption(failure)));
                    }
                    catch (IOException e) {
                        this.logger.warn("Couldn't mark store corrupted", e, new Object[0]);
                    }
                }
                this.failedEngineListener.onFailedEngine(this.shardId, reason, failure);
            }
            catch (Throwable t) {
                this.logger.warn("failEngine threw exception", t, new Object[0]);
            }
            finally {
                this.store.decRef();
            }
        } else {
            this.logger.debug("tried to fail engine but could not acquire lock - engine should be failed by now [{}]", reason, failure);
        }
    }

    protected boolean maybeFailEngine(String source, Throwable t) {
        if (Lucene.isCorruptionException(t)) {
            this.failEngine("corrupt file (source: [" + source + "])", t);
            return true;
        }
        if (ExceptionsHelper.isOOM(t)) {
            this.failEngine("out of memory (source: [" + source + "])", t);
            return true;
        }
        return false;
    }

    protected Throwable wrapIfClosed(Throwable t) {
        if (this.isClosed.get()) {
            if (t != this.failedEngine && this.failedEngine != null) {
                t.addSuppressed(this.failedEngine);
            }
            return new EngineClosedException(this.shardId, t);
        }
        return t;
    }

    protected abstract SearcherManager getSearcherManager();

    protected abstract void closeNoLock(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAndClose() throws IOException {
        if (!this.isClosed.get()) {
            this.logger.trace("flushAndClose now acquire writeLock", new Object[0]);
            try (ReleasableLock lock = this.writeLock.acquire();){
                this.logger.trace("flushAndClose now acquired writeLock", new Object[0]);
                try {
                    this.logger.debug("flushing shard on close - this might take some time to sync files to disk", new Object[0]);
                    try {
                        this.flush();
                    }
                    catch (FlushNotAllowedEngineException ex) {
                        this.logger.debug("flush not allowed during flushAndClose - skipping", new Object[0]);
                    }
                    catch (EngineClosedException ex) {
                        this.logger.debug("engine already closed - skipping flushAndClose", new Object[0]);
                    }
                }
                finally {
                    this.close();
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed.get()) {
            this.logger.debug("close now acquiring writeLock", new Object[0]);
            try (ReleasableLock lock = this.writeLock.acquire();){
                this.logger.debug("close acquired writeLock", new Object[0]);
                this.closeNoLock("api");
            }
        }
    }

    public abstract boolean hasUncommittedChanges();

    public void onSettingsChanged() {
    }

    public static class CommitId
    implements Writeable {
        private final byte[] id;

        public CommitId(byte[] id) {
            assert (id != null);
            this.id = Arrays.copyOf(id, id.length);
        }

        public CommitId(StreamInput in) throws IOException {
            assert (in != null);
            this.id = in.readByteArray();
        }

        public String toString() {
            return Base64.encodeBytes(this.id);
        }

        @Override
        public CommitId readFrom(StreamInput in) throws IOException {
            return new CommitId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByteArray(this.id);
        }

        public boolean idsEqual(byte[] id) {
            return Arrays.equals(id, this.id);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CommitId commitId = (CommitId)o;
            return Arrays.equals(this.id, commitId.id);
        }

        public int hashCode() {
            return Arrays.hashCode(this.id);
        }
    }

    public static class GetResult {
        private final boolean exists;
        private final long version;
        private final Translog.Source source;
        private final Versions.DocIdAndVersion docIdAndVersion;
        private final Searcher searcher;
        public static final GetResult NOT_EXISTS = new GetResult(false, -1L, null);

        public GetResult(boolean exists, long version, @Nullable Translog.Source source) {
            this.source = source;
            this.exists = exists;
            this.version = version;
            this.docIdAndVersion = null;
            this.searcher = null;
        }

        public GetResult(Searcher searcher, Versions.DocIdAndVersion docIdAndVersion) {
            this.exists = true;
            this.source = null;
            this.version = docIdAndVersion.version;
            this.docIdAndVersion = docIdAndVersion;
            this.searcher = searcher;
        }

        public boolean exists() {
            return this.exists;
        }

        public long version() {
            return this.version;
        }

        @Nullable
        public Translog.Source source() {
            return this.source;
        }

        public Searcher searcher() {
            return this.searcher;
        }

        public Versions.DocIdAndVersion docIdAndVersion() {
            return this.docIdAndVersion;
        }

        public void release() {
            if (this.searcher != null) {
                this.searcher.close();
            }
        }
    }

    public static class Get {
        private final boolean realtime;
        private final Term uid;
        private long version = -3L;
        private VersionType versionType = VersionType.INTERNAL;

        public Get(boolean realtime, Term uid) {
            this.realtime = realtime;
            this.uid = uid;
        }

        public boolean realtime() {
            return this.realtime;
        }

        public Term uid() {
            return this.uid;
        }

        public long version() {
            return this.version;
        }

        public Get version(long version) {
            this.version = version;
            return this;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        public Get versionType(VersionType versionType) {
            this.versionType = versionType;
            return this;
        }
    }

    public static class DeleteByQuery {
        private final Query query;
        private final BytesReference source;
        private final String[] filteringAliases;
        private final Query aliasFilter;
        private final String[] types;
        private final BitSetProducer parentFilter;
        private final Operation.Origin origin;
        private final long startTime;
        private long endTime;

        public DeleteByQuery(Query query, BytesReference source, @Nullable String[] filteringAliases, @Nullable Query aliasFilter, BitSetProducer parentFilter, Operation.Origin origin, long startTime, String ... types) {
            this.query = query;
            this.source = source;
            this.types = types;
            this.filteringAliases = filteringAliases;
            this.aliasFilter = aliasFilter;
            this.parentFilter = parentFilter;
            this.startTime = startTime;
            this.origin = origin;
        }

        public Query query() {
            return this.query;
        }

        public BytesReference source() {
            return this.source;
        }

        public String[] types() {
            return this.types;
        }

        public String[] filteringAliases() {
            return this.filteringAliases;
        }

        public Query aliasFilter() {
            return this.aliasFilter;
        }

        public boolean nested() {
            return this.parentFilter != null;
        }

        public BitSetProducer parentFilter() {
            return this.parentFilter;
        }

        public Operation.Origin origin() {
            return this.origin;
        }

        public long startTime() {
            return this.startTime;
        }

        public DeleteByQuery endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public long endTime() {
            return this.endTime;
        }
    }

    public static class Delete
    implements Operation {
        private final String type;
        private final String id;
        private final Term uid;
        private long version;
        private final VersionType versionType;
        private final Operation.Origin origin;
        private boolean found;
        private final long startTime;
        private long endTime;
        private Translog.Location location;

        public Delete(String type, String id, Term uid, long version, VersionType versionType, Operation.Origin origin, long startTime, boolean found) {
            this.type = type;
            this.id = id;
            this.uid = uid;
            this.version = version;
            this.versionType = versionType;
            this.origin = origin;
            this.startTime = startTime;
            this.found = found;
        }

        public Delete(String type, String id, Term uid) {
            this(type, id, uid, -3L, VersionType.INTERNAL, Operation.Origin.PRIMARY, System.nanoTime(), false);
        }

        public Delete(Delete template, VersionType versionType) {
            this(template.type(), template.id(), template.uid(), template.version(), versionType, template.origin(), template.startTime(), template.found());
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.DELETE;
        }

        @Override
        public Operation.Origin origin() {
            return this.origin;
        }

        public String type() {
            return this.type;
        }

        public String id() {
            return this.id;
        }

        public Term uid() {
            return this.uid;
        }

        public void updateVersion(long version, boolean found) {
            this.version = version;
            this.found = found;
        }

        public long version() {
            return this.version;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        public boolean found() {
            return this.found;
        }

        @Override
        public long startTime() {
            return this.startTime;
        }

        public void endTime(long endTime) {
            this.endTime = endTime;
        }

        public long endTime() {
            return this.endTime;
        }

        public void setTranslogLocation(Translog.Location location) {
            this.location = location;
        }

        public Translog.Location getTranslogLocation() {
            return this.location;
        }
    }

    public static final class Index
    extends IndexingOperation {
        public Index(Term uid, ParsedDocument doc, long version, VersionType versionType, Operation.Origin origin, long startTime, boolean canHaveDuplicates) {
            super(uid, doc, version, versionType, origin, startTime, canHaveDuplicates);
        }

        public Index(Term uid, ParsedDocument doc, long version, VersionType versionType, Operation.Origin origin, long startTime) {
            super(uid, doc, version, versionType, origin, startTime, true);
        }

        public Index(Term uid, ParsedDocument doc) {
            super(uid, doc);
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.INDEX;
        }

        @Override
        public boolean execute(IndexShard shard) {
            return shard.index(this);
        }
    }

    public static final class Create
    extends IndexingOperation {
        private final boolean autoGeneratedId;

        public Create(Term uid, ParsedDocument doc, long version, VersionType versionType, Operation.Origin origin, long startTime, boolean canHaveDuplicates, boolean autoGeneratedId) {
            super(uid, doc, version, versionType, origin, startTime, canHaveDuplicates);
            this.autoGeneratedId = autoGeneratedId;
        }

        public Create(Term uid, ParsedDocument doc, long version, VersionType versionType, Operation.Origin origin, long startTime) {
            this(uid, doc, version, versionType, origin, startTime, true, false);
        }

        public Create(Term uid, ParsedDocument doc) {
            super(uid, doc);
            this.autoGeneratedId = false;
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.CREATE;
        }

        public boolean autoGeneratedId() {
            return this.autoGeneratedId;
        }

        @Override
        public boolean execute(IndexShard shard) {
            shard.create(this);
            return true;
        }
    }

    public static abstract class IndexingOperation
    implements Operation {
        private final Term uid;
        private final ParsedDocument doc;
        private long version;
        private final VersionType versionType;
        private final Operation.Origin origin;
        private final boolean canHaveDuplicates;
        private Translog.Location location;
        private final long startTime;
        private long endTime;

        public IndexingOperation(Term uid, ParsedDocument doc, long version, VersionType versionType, Operation.Origin origin, long startTime, boolean canHaveDuplicates) {
            this.uid = uid;
            this.doc = doc;
            this.version = version;
            this.versionType = versionType;
            this.origin = origin;
            this.startTime = startTime;
            this.canHaveDuplicates = canHaveDuplicates;
        }

        public IndexingOperation(Term uid, ParsedDocument doc) {
            this(uid, doc, -3L, VersionType.INTERNAL, Operation.Origin.PRIMARY, System.nanoTime(), true);
        }

        @Override
        public Operation.Origin origin() {
            return this.origin;
        }

        public ParsedDocument parsedDoc() {
            return this.doc;
        }

        public Term uid() {
            return this.uid;
        }

        public String type() {
            return this.doc.type();
        }

        public String id() {
            return this.doc.id();
        }

        public String routing() {
            return this.doc.routing();
        }

        public long timestamp() {
            return this.doc.timestamp();
        }

        public long ttl() {
            return this.doc.ttl();
        }

        public long version() {
            return this.version;
        }

        public void updateVersion(long version) {
            this.version = version;
            this.doc.version().setLongValue(version);
        }

        public void setTranslogLocation(Translog.Location location) {
            this.location = location;
        }

        public Translog.Location getTranslogLocation() {
            return this.location;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        public boolean canHaveDuplicates() {
            return this.canHaveDuplicates;
        }

        public String parent() {
            return this.doc.parent();
        }

        public List<ParseContext.Document> docs() {
            return this.doc.docs();
        }

        public BytesReference source() {
            return this.doc.source();
        }

        @Override
        public long startTime() {
            return this.startTime;
        }

        public void endTime(long endTime) {
            this.endTime = endTime;
        }

        public long endTime() {
            return this.endTime;
        }

        public abstract boolean execute(IndexShard var1);
    }

    public static interface Operation {
        public Type opType();

        public Origin origin();

        public long startTime();

        public static enum Origin {
            PRIMARY,
            REPLICA,
            RECOVERY;

        }

        public static enum Type {
            CREATE,
            INDEX,
            DELETE;

        }
    }

    public static class Searcher
    implements Releasable {
        private final String source;
        private final IndexSearcher searcher;

        public Searcher(String source, IndexSearcher searcher) {
            this.source = source;
            this.searcher = searcher;
        }

        public String source() {
            return this.source;
        }

        public IndexReader reader() {
            return this.searcher.getIndexReader();
        }

        public DirectoryReader getDirectoryReader() {
            if (this.reader() instanceof DirectoryReader) {
                return (DirectoryReader)this.reader();
            }
            throw new IllegalStateException("Can't use " + this.reader().getClass() + " as a directory reader");
        }

        public IndexSearcher searcher() {
            return this.searcher;
        }

        @Override
        public void close() {
        }
    }

    public static interface FailedEngineListener {
        public void onFailedEngine(ShardId var1, String var2, @Nullable Throwable var3);
    }

    public static enum SyncedFlushResult {
        SUCCESS,
        COMMIT_MISMATCH,
        PENDING_OPERATIONS;

    }

    protected static final class NoOpLock
    implements Lock {
        protected NoOpLock() {
        }

        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public void unlock() {
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("NoOpLock can't provide a condition");
        }
    }

    protected static final class IndexThrottle {
        private static final ReleasableLock NOOP_LOCK = new ReleasableLock(new NoOpLock());
        private final ReleasableLock lockReference = new ReleasableLock(new ReentrantLock());
        private volatile ReleasableLock lock = NOOP_LOCK;

        protected IndexThrottle() {
        }

        public Releasable acquireThrottle() {
            return this.lock.acquire();
        }

        public void activate() {
            assert (this.lock == NOOP_LOCK) : "throttling activated while already active";
            this.lock = this.lockReference;
        }

        public void deactivate() {
            assert (this.lock != NOOP_LOCK) : "throttling deactivated but not active";
            this.lock = NOOP_LOCK;
        }
    }
}

