/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.similarity;

import com.google.common.collect.Maps;
import java.util.Map;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Scopes;
import org.elasticsearch.common.inject.assistedinject.FactoryProvider;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.similarity.BM25SimilarityProvider;
import org.elasticsearch.index.similarity.DFRSimilarityProvider;
import org.elasticsearch.index.similarity.DefaultSimilarityProvider;
import org.elasticsearch.index.similarity.IBSimilarityProvider;
import org.elasticsearch.index.similarity.LMDirichletSimilarityProvider;
import org.elasticsearch.index.similarity.LMJelinekMercerSimilarityProvider;
import org.elasticsearch.index.similarity.PreBuiltSimilarityProvider;
import org.elasticsearch.index.similarity.Similarities;
import org.elasticsearch.index.similarity.SimilarityLookupService;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.index.similarity.SimilarityService;

public class SimilarityModule
extends AbstractModule {
    public static final String SIMILARITY_SETTINGS_PREFIX = "index.similarity";
    private final Settings settings;
    private final Map<String, Class<? extends SimilarityProvider>> similarities = Maps.newHashMap();

    public SimilarityModule(Settings settings) {
        this.settings = settings;
        this.addSimilarity("default", DefaultSimilarityProvider.class);
        this.addSimilarity("BM25", BM25SimilarityProvider.class);
        this.addSimilarity("DFR", DFRSimilarityProvider.class);
        this.addSimilarity("IB", IBSimilarityProvider.class);
        this.addSimilarity("LMDirichlet", LMDirichletSimilarityProvider.class);
        this.addSimilarity("LMJelinekMercer", LMJelinekMercerSimilarityProvider.class);
    }

    public void addSimilarity(String name, Class<? extends SimilarityProvider> similarity) {
        this.similarities.put(name, similarity);
    }

    @Override
    protected void configure() {
        MapBinder<String, SimilarityProvider.Factory> similarityBinder = MapBinder.newMapBinder(this.binder(), String.class, SimilarityProvider.Factory.class);
        Map<String, Settings> similaritySettings = this.settings.getGroups(SIMILARITY_SETTINGS_PREFIX);
        for (Map.Entry<String, Settings> entry : similaritySettings.entrySet()) {
            String name = entry.getKey();
            Settings settings = entry.getValue();
            String typeName = settings.get("type");
            if (typeName == null) {
                throw new IllegalArgumentException("Similarity [" + name + "] must have an associated type");
            }
            if (!this.similarities.containsKey(typeName)) {
                throw new IllegalArgumentException("Unknown Similarity type [" + typeName + "] for [" + name + "]");
            }
            similarityBinder.addBinding(entry.getKey()).toProvider(FactoryProvider.newFactory(SimilarityProvider.Factory.class, this.similarities.get(typeName))).in(Scopes.SINGLETON);
        }
        for (PreBuiltSimilarityProvider.Factory factory : Similarities.listFactories()) {
            if (this.similarities.containsKey(factory.name())) continue;
            similarityBinder.addBinding(factory.name()).toInstance(factory);
        }
        this.bind(SimilarityLookupService.class).asEagerSingleton();
        this.bind(SimilarityService.class).asEagerSingleton();
    }
}

