/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.groovy;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorer;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.LeafSearchScript;
import org.elasticsearch.script.ScoreAccessor;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.script.groovy.GroovyScriptCompilationException;
import org.elasticsearch.script.groovy.GroovyScriptExecutionException;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;

public class GroovyScriptEngineService
extends AbstractComponent
implements ScriptEngineService {
    public static final String NAME = "groovy";
    public static final String GROOVY_INDY_ENABLED = "script.groovy.indy";
    public static final String GROOVY_INDY_SETTING_NAME = "indy";
    private final GroovyClassLoader loader;

    @Inject
    public GroovyScriptEngineService(Settings settings) {
        super(settings);
        ImportCustomizer imports = new ImportCustomizer();
        imports.addStarImports(new String[]{"org.joda.time"});
        imports.addStaticStars(new String[]{"java.lang.Math"});
        CompilerConfiguration config = new CompilerConfiguration();
        config.addCompilationCustomizers(new CompilationCustomizer[]{imports});
        config.addCompilationCustomizers(new CompilationCustomizer[]{new GroovyBigDecimalTransformer(CompilePhase.CONVERSION)});
        if (settings.getAsBoolean(GROOVY_INDY_ENABLED, (Boolean)true).booleanValue()) {
            config.getOptimizationOptions().put(GROOVY_INDY_SETTING_NAME, true);
        }
        this.loader = new GroovyClassLoader(this.getClass().getClassLoader(), config);
    }

    @Override
    public void close() {
        this.loader.clearCache();
        try {
            this.loader.close();
        }
        catch (IOException e) {
            this.logger.warn("Unable to close Groovy loader", e, new Object[0]);
        }
    }

    @Override
    public void scriptRemoved(@Nullable CompiledScript script) {
        if (script == null || NAME.equals(script.lang())) {
            this.loader.clearCache();
        }
    }

    @Override
    public String[] types() {
        return new String[]{NAME};
    }

    @Override
    public String[] extensions() {
        return new String[]{NAME};
    }

    @Override
    public boolean sandboxed() {
        return false;
    }

    @Override
    public Object compile(String script) {
        try {
            return this.loader.parseClass(script, Hashing.sha1().hashString((CharSequence)script, Charsets.UTF_8).toString());
        }
        catch (Throwable e) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("exception compiling Groovy script:", e, new Object[0]);
            }
            throw new GroovyScriptCompilationException("failed to compile groovy script", e);
        }
    }

    private Script createScript(Object compiledScript, Map<String, Object> vars) throws InstantiationException, IllegalAccessException {
        Class scriptClass = (Class)compiledScript;
        Script scriptObject = (Script)scriptClass.newInstance();
        Binding binding = new Binding();
        binding.getVariables().putAll(vars);
        scriptObject.setBinding(binding);
        return scriptObject;
    }

    @Override
    public ExecutableScript executable(CompiledScript compiledScript, Map<String, Object> vars) {
        try {
            HashMap<String, Object> allVars = new HashMap<String, Object>();
            if (vars != null) {
                allVars.putAll(vars);
            }
            return new GroovyScript(compiledScript, this.createScript(compiledScript.compiled(), allVars), this.logger);
        }
        catch (Exception e) {
            throw new ScriptException("failed to build executable " + compiledScript, e);
        }
    }

    @Override
    public SearchScript search(final CompiledScript compiledScript, final SearchLookup lookup, final @Nullable Map<String, Object> vars) {
        return new SearchScript(){

            @Override
            public LeafSearchScript getLeafSearchScript(LeafReaderContext context) throws IOException {
                Script scriptObject;
                LeafSearchLookup leafLookup = lookup.getLeafSearchLookup(context);
                HashMap<String, Object> allVars = new HashMap<String, Object>();
                allVars.putAll((Map<String, Object>)leafLookup.asMap());
                if (vars != null) {
                    allVars.putAll(vars);
                }
                try {
                    scriptObject = GroovyScriptEngineService.this.createScript(compiledScript.compiled(), allVars);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new ScriptException("failed to build search " + compiledScript, e);
                }
                return new GroovyScript(compiledScript, scriptObject, leafLookup, GroovyScriptEngineService.this.logger);
            }

            @Override
            public boolean needsScores() {
                return true;
            }
        };
    }

    @Override
    public Object execute(CompiledScript compiledScript, Map<String, Object> vars) {
        try {
            HashMap<String, Object> allVars = new HashMap<String, Object>();
            if (vars != null) {
                allVars.putAll(vars);
            }
            Script scriptObject = this.createScript(compiledScript.compiled(), allVars);
            return scriptObject.run();
        }
        catch (Exception e) {
            throw new ScriptException("failed to execute " + compiledScript, e);
        }
    }

    @Override
    public Object unwrap(Object value) {
        return value;
    }

    private class BigDecimalExpressionTransformer
    extends ClassCodeExpressionTransformer {
        private final SourceUnit source;

        private BigDecimalExpressionTransformer(SourceUnit source) {
            this.source = source;
        }

        protected SourceUnit getSourceUnit() {
            return this.source;
        }

        public Expression transform(Expression expr) {
            ConstantExpression constExpr;
            Object val;
            Expression newExpr = expr;
            if (expr instanceof ConstantExpression && (val = (constExpr = (ConstantExpression)expr).getValue()) != null && val instanceof BigDecimal) {
                newExpr = new ConstantExpression((Object)((BigDecimal)val).doubleValue());
            }
            return super.transform(newExpr);
        }
    }

    private class GroovyBigDecimalTransformer
    extends CompilationCustomizer {
        private GroovyBigDecimalTransformer(CompilePhase phase) {
            super(phase);
        }

        public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
            new BigDecimalExpressionTransformer(source).visitClass(classNode);
        }
    }

    public static final class GroovyScript
    implements ExecutableScript,
    LeafSearchScript {
        private final CompiledScript compiledScript;
        private final Script script;
        private final LeafSearchLookup lookup;
        private final Map<String, Object> variables;
        private final ESLogger logger;

        public GroovyScript(CompiledScript compiledScript, Script script, ESLogger logger) {
            this(compiledScript, script, null, logger);
        }

        public GroovyScript(CompiledScript compiledScript, Script script, @Nullable LeafSearchLookup lookup, ESLogger logger) {
            this.compiledScript = compiledScript;
            this.script = script;
            this.lookup = lookup;
            this.logger = logger;
            this.variables = script.getBinding().getVariables();
        }

        @Override
        public void setScorer(Scorer scorer) {
            this.variables.put("_score", new ScoreAccessor(scorer));
        }

        @Override
        public void setDocument(int doc) {
            if (this.lookup != null) {
                this.lookup.setDocument(doc);
            }
        }

        @Override
        public void setNextVar(String name, Object value) {
            this.variables.put(name, value);
        }

        @Override
        public void setSource(Map<String, Object> source) {
            if (this.lookup != null) {
                this.lookup.source().setSource(source);
            }
        }

        @Override
        public Object run() {
            try {
                return this.script.run();
            }
            catch (Throwable e) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("failed to run " + this.compiledScript, e, new Object[0]);
                }
                throw new GroovyScriptExecutionException("failed to run " + this.compiledScript, e);
            }
        }

        @Override
        public float runAsFloat() {
            return ((Number)this.run()).floatValue();
        }

        @Override
        public long runAsLong() {
            return ((Number)this.run()).longValue();
        }

        @Override
        public double runAsDouble() {
            return ((Number)this.run()).doubleValue();
        }

        @Override
        public Object unwrap(Object value) {
            return value;
        }
    }
}

