/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.LinkedList;
import java.util.Stack;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.VerticalBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BreakFormula {
    public static Box split(Box box, float f, float f2) {
        if (box instanceof HorizontalBox) {
            return BreakFormula.split((HorizontalBox)box, f, f2);
        }
        if (box instanceof VerticalBox) {
            return BreakFormula.split((VerticalBox)box, f, f2);
        }
        return box;
    }

    public static Box split(HorizontalBox horizontalBox, float f, float f2) {
        VerticalBox verticalBox = new VerticalBox();
        HorizontalBox horizontalBox2 = null;
        Stack<Position> stack = new Stack<Position>();
        float f3 = -1.0f;
        while (horizontalBox.width > f && (f3 = BreakFormula.canBreak(stack, horizontalBox, f)) != horizontalBox.width) {
            Position position = stack.pop();
            HorizontalBox[] horizontalBoxArray = position.hbox.split(position.index - 1);
            HorizontalBox horizontalBox3 = horizontalBoxArray[0];
            horizontalBox2 = horizontalBoxArray[1];
            while (!stack.isEmpty()) {
                position = stack.pop();
                horizontalBoxArray = position.hbox.splitRemove(position.index);
                horizontalBoxArray[0].add(horizontalBox3);
                horizontalBoxArray[1].add(0, horizontalBox2);
                horizontalBox3 = horizontalBoxArray[0];
                horizontalBox2 = horizontalBoxArray[1];
            }
            verticalBox.add(horizontalBox3, f2);
            horizontalBox = horizontalBox2;
        }
        if (horizontalBox2 != null) {
            verticalBox.add(horizontalBox2, f2);
            return verticalBox;
        }
        return horizontalBox;
    }

    private static Box split(VerticalBox verticalBox, float f, float f2) {
        VerticalBox verticalBox2 = new VerticalBox();
        for (Box box : verticalBox.children) {
            verticalBox2.add(BreakFormula.split(box, f, f2));
        }
        return verticalBox2;
    }

    private static float canBreak(Stack<Position> stack, HorizontalBox horizontalBox, float f) {
        LinkedList linkedList = horizontalBox.children;
        float[] fArray = new float[linkedList.size() + 1];
        fArray[0] = 0.0f;
        for (int i = 0; i < linkedList.size(); ++i) {
            Stack<Position> stack2;
            float f2;
            Box box = (Box)linkedList.get(i);
            fArray[i + 1] = fArray[i] + box.width;
            if (!(fArray[i + 1] > f)) continue;
            int n = BreakFormula.getBreakPosition(horizontalBox, i);
            if (box instanceof HorizontalBox && (f2 = BreakFormula.canBreak(stack2 = new Stack<Position>(), (HorizontalBox)box, f - fArray[i])) != box.width && (fArray[i] + f2 <= f || n == -1)) {
                stack.push(new Position(i - 1, horizontalBox));
                stack.addAll(stack2);
                return fArray[i] + f2;
            }
            if (n == -1) continue;
            stack.push(new Position(n, horizontalBox));
            return fArray[n];
        }
        return horizontalBox.width;
    }

    private static int getBreakPosition(HorizontalBox horizontalBox, int n) {
        int n2;
        if (horizontalBox.breakPositions == null) {
            return -1;
        }
        if (horizontalBox.breakPositions.size() == 1 && horizontalBox.breakPositions.get(0) <= n) {
            return horizontalBox.breakPositions.get(0);
        }
        for (n2 = 0; n2 < horizontalBox.breakPositions.size(); ++n2) {
            if (horizontalBox.breakPositions.get(n2) <= n) continue;
            if (n2 == 0) {
                return -1;
            }
            return horizontalBox.breakPositions.get(n2 - 1);
        }
        return horizontalBox.breakPositions.get(n2 - 1);
    }

    private static class Position {
        int index;
        HorizontalBox hbox;

        Position(int n, HorizontalBox horizontalBox) {
            this.index = n;
            this.hbox = horizontalBox;
        }
    }
}

