

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:Garmin MapSource - gdb (gdb){/block}
  {block name=body}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">Garmin MapSource - gdb (gdb)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="fmt_glogbook.html">Prev</a> </td><th width="60%" align="center">Chapter 3. The Formats</th><td width="20%" align="right"> <a accesskey="n" href="fmt_mapsource.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="fmt_gdb"></a>Garmin MapSource - gdb (gdb)</h2></div></div></div><p class="fmtcapshdr">
    This format can...
    </p><div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; "><li class="listitem"><p class="fmtcapsitem">
          read and write waypoints
        </p></li><li class="listitem"><p class="fmtcapsitem">
          read and write tracks
        </p></li><li class="listitem"><p class="fmtcapsitem">
          read and write routes
        </p></li></ul></div><p>This format has the following options: <a class="link" href="fmt_gdb.html#fmt_gdb_o_cat" title="cat option">cat</a>, <a class="link" href="fmt_gdb.html#fmt_gdb_o_bitscategory" title="bitscategory option">bitscategory</a>, <a class="link" href="fmt_gdb.html#fmt_gdb_o_ver" title="ver option">ver</a>, <a class="link" href="fmt_gdb.html#fmt_gdb_o_via" title="via option">via</a>, <a class="link" href="fmt_gdb.html#fmt_gdb_o_roadbook" title="roadbook option">roadbook</a> .</p><p> 
  Support for the "Garmin GPS Database" format used by
  default in <span class="productname">MapSource</span>™ versions since release 6.0 of 
  that product. By default GPSBabel creates
  gdb files of version 2.  Version 2 is used in Mapsource 6.3 and 6.5.   This format
  is also used by <span class="productname">Garmin BaseCamp</span>™ for Mac and Windows.
</p><p> 
  Garmin GPS database is an undocumented file format. The
  basic info for this module came from the existing MapSource
  conversion code.
</p><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_gdb_o_cat"></a><code class="option">cat</code> option</h3></div></div></div><p>
      Default category on output (1..16).
    </p><p>
This option specifies the default category for gdb output.  It should be a 
number from 1 to 16.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_gdb_o_bitscategory"></a><code class="option">bitscategory</code> option</h3></div></div></div><p>
      Bitmap of categories.
    </p><p>
 This option is closely related to the 'category' option.  While category 
 allows you to choose a single category that waypoints should appear in,
 this options allows you to specify a bitmask to be used for the category.
 Options may be specified in either decimal or hex.
</p><div class="example"><a id="gdb_bitscategory"></a><p class="title"><strong>Example 3.6. Example for gdb bitcategory option to put all waypoints in categories 1 and 16.</strong></p><div class="example-contents"><p>
  The following two commands are equivalent.  They place a the point in both the first and last of the sixteen available categories.
  <strong class="userinput"><code>
	 gpsbabel -i gpx -f PocketQuery.gpx -o gdb,bitscategory=32769 -F foo.gdb
  </code></strong>
  <strong class="userinput"><code>
	 gpsbabel -i gpx -f PocketQuery.gpx -o gdb,bitscategory=0x8001 -F foo.gdb
  </code></strong>
  
</p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_gdb_o_ver"></a><code class="option">ver</code> option</h3></div></div></div><p>
      Version of gdb file to generate (1..3).
    </p><p>
This option specifies the data format version for the output file.  Version
2 is the default.  Currently, the only other valid values for this option are
1 and 3.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_gdb_o_via"></a><code class="option">via</code> option</h3></div></div></div><p>
      Drop route points that do not have an equivalent waypoint (hidden points).
    </p><p>
This option instructs GPSBabel to drop hidden (calculated) points from 
routes.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_gdb_o_roadbook"></a><code class="option">roadbook</code> option</h3></div></div></div><p>
      Include major turn points (with description) from calculated route.
    </p><p>
  If this option is specified, GPSBabel drops all calculated route points, 
  with exception of points with a description (i.e. "Make U-turns until you know where you are.").
  The priority of this option is higher than of the <code class="option">via</code> option. 
  A value of 1 or y overwrites the <code class="option">via</code> settings.
</p><div class="example"><a id="gdb_roadbook_option"></a><p class="title"><strong>Example 3.7. Using gdb option <code class="option">roadbook</code> to create simple html roadbook</strong></p><div class="example-contents"><p>
    <strong class="userinput"><code>
      gpsbabel -i gdb,roadbook -f sample.gdb -x nuketypes,waypoints,tracks -x transform,wpt=rte -o html -F roadbook.html
    </code></strong>
  </p><p>
    Because gdb internally creates a route AND a waypoint list, you have to drop all
    waypoints and transform the route into waypoints in order to get a well ordered
    html output. We suggest these steps for all waypoint-only formats as html. 
  </p></div></div><br class="example-break" /></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="fmt_glogbook.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="The_Formats.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="fmt_mapsource.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Garmin Logbook XML (glogbook) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Garmin MapSource - mps (mapsource)</td></tr></table></div>
  
      {/block}
  