/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.IndependentLogFilter;
import com.intellij.diagnostic.logging.LogFilter;
import com.intellij.diagnostic.logging.LogFilterListener;
import com.intellij.diagnostic.logging.LogFilterRegistrar;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="LogFilters", storages={@Storage(file="$WORKSPACE_FILE$")})
public class LogConsolePreferences
extends LogFilterRegistrar {
    private final SortedMap<LogFilter, Boolean> myRegisteredLogFilters = new TreeMap<LogFilter, Boolean>(new Comparator<LogFilter>(){

        @Override
        public int compare(LogFilter o1, LogFilter o2) {
            return -1;
        }
    });
    @NonNls
    private static final String FILTER = "filter";
    @NonNls
    private static final String IS_ACTIVE = "is_active";
    public boolean FILTER_ERRORS = false;
    public boolean FILTER_WARNINGS = false;
    public boolean FILTER_INFO = true;
    public boolean FILTER_DEBUG = true;
    public String CUSTOM_FILTER = null;
    @NonNls
    public static final String ERROR = "ERROR";
    @NonNls
    public static final String WARNING = "WARNING";
    @NonNls
    private static final String WARN = "WARN";
    @NonNls
    public static final String INFO = "INFO";
    @NonNls
    public static final String DEBUG = "DEBUG";
    @NonNls
    public static final String CUSTOM = "CUSTOM";
    public static final Pattern ERROR_PATTERN = Pattern.compile(".*(ERROR|FATAL).*");
    public static final Pattern WARNING_PATTERN = Pattern.compile(".*WARNING.*");
    public static final Pattern WARN_PATTERN = Pattern.compile(".*WARN.*");
    public static final Pattern INFO_PATTERN = Pattern.compile(".*INFO.*");
    public static final Pattern DEBUG_PATTERN = Pattern.compile(".*DEBUG.*");
    @NonNls
    public static final Pattern EXCEPTION_PATTERN = Pattern.compile(".*at .*");
    private final List<LogFilterListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final Logger LOG = Logger.getInstance((String)("#" + LogConsolePreferences.class.getName()));

    public static LogConsolePreferences getInstance(Project project) {
        return ServiceManager.getService(project, LogConsolePreferences.class);
    }

    public void updateCustomFilter(String customFilter) {
        this.CUSTOM_FILTER = customFilter;
        this.fireStateChanged();
    }

    public boolean isApplicable(@NotNull String text, String prevType, boolean checkStandardFilters) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diagnostic/logging/LogConsolePreferences", "isApplicable"));
        }
        for (LogFilter filter : this.myRegisteredLogFilters.keySet()) {
            if (!((Boolean)this.myRegisteredLogFilters.get(filter)).booleanValue() || filter.isAcceptable(text)) continue;
            return false;
        }
        if (checkStandardFilters) {
            String type = LogConsolePreferences.getType(text);
            boolean selfTyped = false;
            if (type != null) {
                if (!this.isApplicable(type)) {
                    return false;
                }
                selfTyped = true;
            }
            return selfTyped || prevType == null || this.isApplicable(prevType);
        }
        return true;
    }

    private boolean isApplicable(String type) {
        if (type.equals(ERROR)) {
            return !this.FILTER_ERRORS;
        }
        if (type.equals(WARNING)) {
            return !this.FILTER_WARNINGS;
        }
        if (type.equals(INFO)) {
            return !this.FILTER_INFO;
        }
        if (type.equals(DEBUG)) {
            return !this.FILTER_DEBUG;
        }
        return true;
    }

    public static ConsoleViewContentType getContentType(String type) {
        if (type.equals(ERROR)) {
            return ConsoleViewContentType.ERROR_OUTPUT;
        }
        return ConsoleViewContentType.NORMAL_OUTPUT;
    }

    @Nullable
    public static String getType(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diagnostic/logging/LogConsolePreferences", "getType"));
        }
        String upcased = StringUtil.toUpperCase((String)text);
        if (ERROR_PATTERN.matcher(upcased).matches()) {
            return ERROR;
        }
        if (WARNING_PATTERN.matcher(upcased).matches() || WARN_PATTERN.matcher(upcased).matches()) {
            return WARNING;
        }
        if (INFO_PATTERN.matcher(upcased).matches()) {
            return INFO;
        }
        if (DEBUG_PATTERN.matcher(upcased).matches()) {
            return DEBUG;
        }
        return null;
    }

    public static Key getProcessOutputTypes(String type) {
        if (type.equals(ERROR)) {
            return ProcessOutputTypes.STDERR;
        }
        if (type.equals(WARNING) || type.equals(INFO) || type.equals(DEBUG)) {
            return ProcessOutputTypes.STDOUT;
        }
        return null;
    }

    @Override
    public Element getState() {
        Element element = new Element("LogFilters");
        try {
            for (LogFilter filter : this.myRegisteredLogFilters.keySet()) {
                Element filterElement = new Element(FILTER);
                filterElement.setAttribute(IS_ACTIVE, ((Boolean)this.myRegisteredLogFilters.get(filter)).toString());
                filter.writeExternal(filterElement);
                element.addContent(filterElement);
            }
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return element;
    }

    @Override
    public void loadState(Element object) {
        try {
            List children = object.getChildren(FILTER);
            for (Object child : children) {
                Element filterElement = (Element)child;
                LogFilter filter = new LogFilter();
                filter.readExternal(filterElement);
                this.setFilterSelected(filter, Boolean.parseBoolean(filterElement.getAttributeValue(IS_ACTIVE)));
            }
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)object);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void registerFilter(LogFilter filter) {
        this.myRegisteredLogFilters.put(filter, Boolean.FALSE);
    }

    @Override
    public List<LogFilter> getRegisteredLogFilters() {
        return new ArrayList<LogFilter>(this.myRegisteredLogFilters.keySet());
    }

    @Override
    public boolean isFilterSelected(LogFilter filter) {
        Boolean isSelected = (Boolean)this.myRegisteredLogFilters.get(filter);
        if (isSelected != null) {
            return isSelected;
        }
        if (filter instanceof IndependentLogFilter) {
            return ((IndependentLogFilter)filter).isSelected();
        }
        return false;
    }

    @Override
    public void setFilterSelected(LogFilter filter, boolean state) {
        if (filter instanceof IndependentLogFilter) {
            ((IndependentLogFilter)filter).selectFilter();
        } else if (this.myRegisteredLogFilters.containsKey(filter)) {
            this.myRegisteredLogFilters.put(filter, state);
        }
        this.fireStateChanged(filter);
    }

    public void selectOnlyFilter(LogFilter filter) {
        for (LogFilter logFilter : this.myRegisteredLogFilters.keySet()) {
            this.myRegisteredLogFilters.put(logFilter, false);
        }
        if (filter != null) {
            this.setFilterSelected(filter, true);
        }
    }

    private void fireStateChanged(LogFilter filter) {
        for (LogFilterListener listener : this.myListeners) {
            listener.onFilterStateChange(filter);
        }
    }

    private void fireStateChanged() {
        for (LogFilterListener listener : this.myListeners) {
            listener.onTextFilterChange();
        }
    }

    public void addFilterListener(LogFilterListener l) {
        this.myListeners.add(l);
    }

    public void removeFilterListener(LogFilterListener l) {
        this.myListeners.remove(l);
    }
}

