/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtil;
import com.pty4j.PtyProcess;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PtyCommandLine
extends GeneralCommandLine {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.configurations.PtyCommandLine");
    public static final String RUN_PROCESSES_WITH_PTY = "run.processes.with.pty";
    private boolean myUseCygwinLaunch;
    private boolean myConsoleMode = true;

    public static boolean isEnabled() {
        return Registry.is((String)RUN_PROCESSES_WITH_PTY);
    }

    @Override
    @NotNull
    protected Process startProcess(@NotNull List<String> commands) throws IOException {
        Process process;
        if (commands == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commands", "com/intellij/execution/configurations/PtyCommandLine", "startProcess"));
        }
        try {
            process = this.startProcessWithPty(commands, this.myConsoleMode);
        }
        catch (Throwable e) {
            File logFile = PtyCommandLine.getPtyLogFile();
            if (ApplicationManager.getApplication().isEAP() && logFile.exists()) {
                String logContent;
                try {
                    logContent = FileUtil.loadFile((File)logFile);
                }
                catch (Exception ignore) {
                    logContent = "Unable to retrieve log";
                }
                LOG.error("Couldn't run process with PTY", e, new String[]{logContent});
            } else {
                LOG.error("Couldn't run process with PTY", e);
            }
            Process process2 = super.startProcess(commands);
            if (process2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PtyCommandLine", "startProcess"));
            }
            return process2;
        }
        if (process == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PtyCommandLine", "startProcess"));
        }
        return process;
    }

    public void setUseCygwinLaunch(boolean useCygwinLaunch) {
        this.myUseCygwinLaunch = useCygwinLaunch;
    }

    public void setConsoleMode(boolean consoleMode) {
        this.myConsoleMode = consoleMode;
    }

    private static File getPtyLogFile() {
        return new File(PathManager.getLogPath(), "pty.log");
    }

    @NotNull
    public Process startProcessWithPty(@NotNull List<String> commands, boolean console) throws IOException {
        if (commands == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commands", "com/intellij/execution/configurations/PtyCommandLine", "startProcessWithPty"));
        }
        HashMap<String, String> env = new HashMap<String, String>();
        this.setupEnvironment(env);
        if (this.isRedirectErrorStream()) {
            LOG.error("Launching process with PTY and redirected error stream is unsupported yet");
        }
        File workDirectory = this.getWorkDirectory();
        boolean cygwin = this.myUseCygwinLaunch && SystemInfo.isWindows;
        PtyProcess ptyProcess = PtyProcess.exec((String[])ArrayUtil.toStringArray(commands), env, (String)(workDirectory != null ? workDirectory.getPath() : null), (boolean)console, (boolean)cygwin, (File)(ApplicationManager.getApplication().isEAP() ? PtyCommandLine.getPtyLogFile() : null));
        if (ptyProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PtyCommandLine", "startProcessWithPty"));
        }
        return ptyProcess;
    }
}

