/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionGroupUtil {
    private static Presentation getPresentation(AnAction action, Map<AnAction, Presentation> action2presentation) {
        Presentation presentation = action2presentation.get(action);
        if (presentation == null) {
            presentation = action.getTemplatePresentation().clone();
            action2presentation.put(action, presentation);
        }
        return presentation;
    }

    public static boolean isGroupEmpty(@NotNull ActionGroup actionGroup, @NotNull AnActionEvent e) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/openapi/actionSystem/ActionGroupUtil", "isGroupEmpty"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/ActionGroupUtil", "isGroupEmpty"));
        }
        return ActionGroupUtil.isGroupEmpty(actionGroup, e, new HashMap<AnAction, Presentation>());
    }

    private static boolean isGroupEmpty(@NotNull ActionGroup actionGroup, @NotNull AnActionEvent e, @NotNull Map<AnAction, Presentation> action2presentation) {
        AnAction[] actions;
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/openapi/actionSystem/ActionGroupUtil", "isGroupEmpty"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/ActionGroupUtil", "isGroupEmpty"));
        }
        if (action2presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action2presentation", "com/intellij/openapi/actionSystem/ActionGroupUtil", "isGroupEmpty"));
        }
        for (AnAction action : actions = actionGroup.getChildren(e)) {
            if (action instanceof Separator || !ActionGroupUtil.isActionEnabledAndVisible(e, action2presentation, action)) continue;
            if (action instanceof ActionGroup) {
                if (ActionGroupUtil.isGroupEmpty((ActionGroup)action, e, action2presentation)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Nullable
    public static AnAction getSingleActiveAction(@NotNull ActionGroup actionGroup, @NotNull AnActionEvent e) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/openapi/actionSystem/ActionGroupUtil", "getSingleActiveAction"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/ActionGroupUtil", "getSingleActiveAction"));
        }
        List<AnAction> children = ActionGroupUtil.getEnabledChildren(actionGroup, e, new HashMap<AnAction, Presentation>());
        if (children.size() == 1) {
            return children.get(0);
        }
        return null;
    }

    private static List<AnAction> getEnabledChildren(@NotNull ActionGroup actionGroup, @NotNull AnActionEvent e, @NotNull Map<AnAction, Presentation> action2presentation) {
        AnAction[] actions;
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/openapi/actionSystem/ActionGroupUtil", "getEnabledChildren"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/ActionGroupUtil", "getEnabledChildren"));
        }
        if (action2presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action2presentation", "com/intellij/openapi/actionSystem/ActionGroupUtil", "getEnabledChildren"));
        }
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        for (AnAction action : actions = actionGroup.getChildren(e)) {
            if (action instanceof ActionGroup) {
                if (!ActionGroupUtil.isActionEnabledAndVisible(e, action2presentation, action)) continue;
                result.addAll(ActionGroupUtil.getEnabledChildren((ActionGroup)action, e, action2presentation));
                continue;
            }
            if (action instanceof Separator || !ActionGroupUtil.isActionEnabledAndVisible(e, action2presentation, action)) continue;
            result.add(action);
        }
        return result;
    }

    private static boolean isActionEnabledAndVisible(@NotNull AnActionEvent e, @NotNull Map<AnAction, Presentation> action2presentation, @NotNull AnAction action) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/ActionGroupUtil", "isActionEnabledAndVisible"));
        }
        if (action2presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action2presentation", "com/intellij/openapi/actionSystem/ActionGroupUtil", "isActionEnabledAndVisible"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/actionSystem/ActionGroupUtil", "isActionEnabledAndVisible"));
        }
        Presentation presentation = ActionGroupUtil.getPresentation(action, action2presentation);
        AnActionEvent event = new AnActionEvent(e.getInputEvent(), e.getDataContext(), "unknown", presentation, ActionManager.getInstance(), e.getModifiers());
        event.setInjectedContext(action.isInInjectedContext());
        ActionUtil.performDumbAwareUpdate(action, event, false);
        return presentation.isEnabled() && presentation.isVisible();
    }
}

