/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ReadonlyList;
import com.intellij.util.containers.StepList;
import java.util.Comparator;

public abstract class GroupingMerger<T, S> {
    private S myCurrentGroup;

    protected boolean filter(T t) {
        return true;
    }

    protected abstract void willBeRecountFrom(int var1, int var2);

    protected abstract S getGroup(T var1);

    protected abstract T wrapGroup(S var1, T var2);

    protected abstract void oldBecame(int var1, int var2);

    protected abstract void afterConsumed(T var1, int var2);

    protected T wrapItem(T t) {
        return t;
    }

    public S getCurrentGroup() {
        return this.myCurrentGroup;
    }

    public int firstPlusSecond(final StepList<T> first, ReadonlyList<T> second, Comparator<T> comparator, int idxFrom) {
        int idx;
        int wasSize = first.getSize();
        if (second.getSize() == 0) {
            return wasSize;
        }
        if (idxFrom == -1) {
            idx = GroupingMerger.stolenBinarySearch(first, second.get(0), comparator, 0);
            if (idx < 0) {
                idx = -(idx + 1);
            }
        } else {
            idx = idxFrom;
        }
        if (idx > 0 && !this.filter(first.get(idx - 1))) {
            --idx;
        }
        ReadonlyList remergePart = first.cut(idx);
        if (idx > 0) {
            this.myCurrentGroup = this.getGroup(first.get(idx - 1));
        }
        final int finalIdx = idx;
        this.willBeRecountFrom(idx, wasSize);
        this.merge(remergePart, second, comparator, new PairConsumer<T, Integer>(){

            public void consume(T t, Integer integer) {
                GroupingMerger.this.doForGroup(t, first);
                first.add(t);
                int was = integer + finalIdx;
                GroupingMerger.this.oldBecame(was, first.getSize() - 1);
            }
        }, new Consumer<T>(){

            public void consume(T t) {
                GroupingMerger.this.doForGroup(t, first);
                Object wrapped = GroupingMerger.this.wrapItem(t);
                first.add(wrapped);
                GroupingMerger.this.afterConsumed(wrapped, first.getSize() - 1);
            }
        });
        return idx;
    }

    private void doForGroup(T t, StepList<T> first) {
        S newGroup = this.getGroup(t);
        if (newGroup != null && !Comparing.equal(newGroup, this.myCurrentGroup)) {
            first.add(this.wrapGroup(newGroup, t));
            this.myCurrentGroup = newGroup;
        }
    }

    public void merge(ReadonlyList<T> one, ReadonlyList<T> two, Comparator<T> comparator, PairConsumer<T, Integer> oldAdder, Consumer<T> newAdder) {
        Object firstOne;
        int idx1 = 0;
        int idx2 = 0;
        while (idx1 < one.getSize() && idx2 < two.getSize()) {
            firstOne = one.get(idx1);
            if (!this.filter(firstOne)) {
                ++idx1;
                continue;
            }
            int comp = comparator.compare(firstOne, two.get(idx2));
            if (comp <= 0) {
                oldAdder.consume(firstOne, (Object)idx1);
                ++idx1;
                if (comp != 0) continue;
                ++idx2;
                continue;
            }
            newAdder.consume(two.get(idx2));
            ++idx2;
        }
        while (idx1 < one.getSize()) {
            firstOne = one.get(idx1);
            if (!this.filter(firstOne)) {
                ++idx1;
                continue;
            }
            oldAdder.consume(one.get(idx1), (Object)idx1);
            ++idx1;
        }
        while (idx2 < two.getSize()) {
            newAdder.consume(two.get(idx2));
            ++idx2;
        }
    }

    private static <T> int stolenBinarySearch(ReadonlyList<? extends T> l, T key, Comparator<? super T> c, int from) {
        int low = from;
        int high = l.getSize() - from - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Object midVal = l.get(mid);
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

