/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.std;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSectionRuleAwareSettings;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.InvertibleArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementStandardSettingsManager {
    @NotNull
    private final TObjectIntHashMap<ArrangementSettingsToken> myWidths;
    @NotNull
    private final TObjectIntHashMap<ArrangementSettingsToken> myWeights;
    @NotNull
    private final Comparator<ArrangementSettingsToken> myComparator;
    @NotNull
    private final ArrangementStandardSettingsAware myDelegate;
    @NotNull
    private final ArrangementColorsProvider myColorsProvider;
    @NotNull
    private final Collection<Set<ArrangementSettingsToken>> myMutexes;
    @Nullable
    private final StdArrangementSettings myDefaultSettings;
    @Nullable
    private final List<CompositeArrangementSettingsToken> myGroupingTokens;
    @Nullable
    private final List<CompositeArrangementSettingsToken> myMatchingTokens;
    @NotNull
    private final Collection<StdArrangementRuleAliasToken> myRuleAliases;
    @NotNull
    private final Set<ArrangementSettingsToken> myRuleAliasMutex;
    @Nullable
    private CompositeArrangementSettingsToken myRuleAliasToken;

    public ArrangementStandardSettingsManager(@NotNull ArrangementStandardSettingsAware delegate, @NotNull ArrangementColorsProvider colorsProvider) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "<init>"));
        }
        if (colorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsProvider", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "<init>"));
        }
        this(delegate, colorsProvider, ContainerUtil.emptyList());
    }

    public ArrangementStandardSettingsManager(@NotNull ArrangementStandardSettingsAware delegate, @NotNull ArrangementColorsProvider colorsProvider, @NotNull Collection<StdArrangementRuleAliasToken> aliases) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "<init>"));
        }
        if (colorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsProvider", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "<init>"));
        }
        if (aliases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliases", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "<init>"));
        }
        this.myWidths = new TObjectIntHashMap();
        this.myWeights = new TObjectIntHashMap();
        this.myComparator = new Comparator<ArrangementSettingsToken>(){

            @Override
            public int compare(ArrangementSettingsToken t1, ArrangementSettingsToken t2) {
                if (ArrangementStandardSettingsManager.this.myWeights.containsKey((Object)t1)) {
                    if (ArrangementStandardSettingsManager.this.myWeights.containsKey((Object)t2)) {
                        return ArrangementStandardSettingsManager.this.myWeights.get((Object)t1) - ArrangementStandardSettingsManager.this.myWeights.get((Object)t2);
                    }
                    return -1;
                }
                if (ArrangementStandardSettingsManager.this.myWeights.containsKey((Object)t2)) {
                    return 1;
                }
                return t1.compareTo(t2);
            }
        };
        this.myDelegate = delegate;
        this.myColorsProvider = colorsProvider;
        this.myMutexes = delegate.getMutexes();
        this.myDefaultSettings = delegate.getDefaultSettings();
        SimpleColoredComponent renderer = new SimpleColoredComponent();
        this.myGroupingTokens = delegate.getSupportedGroupingTokens();
        if (this.myGroupingTokens != null) {
            this.parseWidths(this.myGroupingTokens, renderer);
            this.buildWeights(this.myGroupingTokens);
        }
        this.myMatchingTokens = delegate.getSupportedMatchingTokens();
        if (this.myMatchingTokens != null) {
            this.parseWidths(this.myMatchingTokens, renderer);
            this.buildWeights(this.myMatchingTokens);
        }
        HashSet aliasTokens = ContainerUtil.newHashSet();
        aliasTokens.addAll(aliases);
        this.myRuleAliases = aliases;
        this.myRuleAliasMutex = aliasTokens;
        if (!this.myRuleAliases.isEmpty()) {
            this.myRuleAliasToken = new CompositeArrangementSettingsToken(StdArrangementTokens.General.ALIAS, aliasTokens);
        }
    }

    @NotNull
    public Collection<StdArrangementRuleAliasToken> getRuleAliases() {
        Collection<StdArrangementRuleAliasToken> collection = this.myRuleAliases;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "getRuleAliases"));
        }
        return collection;
    }

    @NotNull
    public ArrangementStandardSettingsAware getDelegate() {
        ArrangementStandardSettingsAware arrangementStandardSettingsAware = this.myDelegate;
        if (arrangementStandardSettingsAware == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "getDelegate"));
        }
        return arrangementStandardSettingsAware;
    }

    private void parseWidths(@NotNull Collection<CompositeArrangementSettingsToken> compositeTokens, @NotNull SimpleColoredComponent renderer) {
        if (compositeTokens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compositeTokens", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "parseWidths"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "parseWidths"));
        }
        int width = 0;
        for (CompositeArrangementSettingsToken compositeToken : compositeTokens) {
            width = Math.max(width, this.parseWidth(compositeToken.getToken(), renderer));
        }
        for (CompositeArrangementSettingsToken compositeToken : compositeTokens) {
            this.myWidths.put((Object)compositeToken.getToken(), width);
            this.parseWidths(compositeToken.getChildren(), renderer);
        }
    }

    private void buildWeights(@NotNull Collection<CompositeArrangementSettingsToken> compositeTokens) {
        if (compositeTokens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compositeTokens", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "buildWeights"));
        }
        for (CompositeArrangementSettingsToken token : compositeTokens) {
            this.myWeights.put((Object)token.getToken(), this.myWeights.size());
            this.buildWeights(token.getChildren());
        }
    }

    @Nullable
    public StdArrangementSettings getDefaultSettings() {
        return this.myDefaultSettings;
    }

    public boolean isSectionRulesSupported() {
        return this.myDelegate instanceof ArrangementSectionRuleAwareSettings;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedGroupingTokens() {
        return this.myGroupingTokens;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedMatchingTokens() {
        if (this.myMatchingTokens == null || this.myRuleAliasToken == null) {
            return this.myMatchingTokens;
        }
        ArrayList allTokens = ContainerUtil.newArrayList(this.myMatchingTokens);
        allTokens.add(this.myRuleAliasToken);
        return allTokens;
    }

    public boolean isEnabled(@NotNull ArrangementSettingsToken token, @Nullable ArrangementMatchCondition current) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "isEnabled"));
        }
        if (this.myRuleAliasMutex.contains(token)) {
            return true;
        }
        return this.myDelegate.isEnabled(token, current);
    }

    @NotNull
    public ArrangementEntryMatcher buildMatcher(@NotNull ArrangementMatchCondition condition) throws IllegalArgumentException {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "buildMatcher"));
        }
        ArrangementEntryMatcher matcher = ArrangementUtil.buildMatcher(condition);
        if (matcher == null) {
            matcher = this.myDelegate.buildMatcher(condition);
        }
        ArrangementEntryMatcher arrangementEntryMatcher = matcher;
        if (arrangementEntryMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "buildMatcher"));
        }
        return arrangementEntryMatcher;
    }

    @NotNull
    public Collection<Set<ArrangementSettingsToken>> getMutexes() {
        if (this.myRuleAliasMutex.isEmpty()) {
            Collection<Set<ArrangementSettingsToken>> collection = this.myMutexes;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "getMutexes"));
            }
            return collection;
        }
        ArrayList allMutexes = ContainerUtil.newArrayList(this.myMutexes);
        allMutexes.add(this.myRuleAliasMutex);
        ArrayList arrayList = allMutexes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "getMutexes"));
        }
        return arrayList;
    }

    public int getWidth(@NotNull ArrangementSettingsToken token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "getWidth"));
        }
        if (this.myWidths.containsKey((Object)token)) {
            return this.myWidths.get((Object)token);
        }
        return this.parseWidth(token, new SimpleColoredComponent());
    }

    private int parseWidth(@NotNull ArrangementSettingsToken token, @NotNull SimpleColoredComponent renderer) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "parseWidth"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "parseWidth"));
        }
        renderer.clear();
        String value = ArrangementStandardSettingsManager.getPresentationValue(token);
        renderer.append(value, SimpleTextAttributes.fromTextAttributes(this.myColorsProvider.getTextAttributes(token, true)));
        int result = renderer.getPreferredSize().width;
        renderer.clear();
        renderer.append(value, SimpleTextAttributes.fromTextAttributes(this.myColorsProvider.getTextAttributes(token, false)));
        return Math.max(result, renderer.getPreferredSize().width);
    }

    @NotNull
    private static String getPresentationValue(@NotNull ArrangementSettingsToken token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "getPresentationValue"));
        }
        if (token instanceof InvertibleArrangementSettingsToken) {
            String string = ((InvertibleArrangementSettingsToken)((Object)token)).getInvertedRepresentationValue();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "getPresentationValue"));
            }
            return string;
        }
        String string = token.getRepresentationValue();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "getPresentationValue"));
        }
        return string;
    }

    public List<ArrangementSettingsToken> sort(@NotNull Collection<ArrangementSettingsToken> tokens) {
        if (tokens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokens", "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager", "sort"));
        }
        ArrayList result = ContainerUtilRt.newArrayList(tokens);
        Collections.sort(result, this.myComparator);
        return result;
    }
}

