/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.actions;

import com.intellij.vcs.log.graph.PrintElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GraphAction {
    @Nullable
    public PrintElement getAffectedElement();

    @NotNull
    public Type getType();

    public static class GraphActionImpl
    implements GraphAction {
        @Nullable
        private final PrintElement myPrintElement;
        @NotNull
        private final Type myActionType;

        public GraphActionImpl(@Nullable PrintElement printElement, @NotNull Type actionType) {
            if (actionType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionType", "com/intellij/vcs/log/graph/actions/GraphAction$GraphActionImpl", "<init>"));
            }
            this.myPrintElement = printElement;
            this.myActionType = actionType;
        }

        @Override
        @Nullable
        public PrintElement getAffectedElement() {
            return this.myPrintElement;
        }

        @Override
        @NotNull
        public Type getType() {
            Type type = this.myActionType;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/actions/GraphAction$GraphActionImpl", "getType"));
            }
            return type;
        }
    }

    public static enum Type {
        MOUSE_CLICK,
        MOUSE_OVER,
        BUTTON_COLLAPSE,
        BUTTON_EXPAND;

    }
}

