/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.snapShooter;

import org.jetbrains.annotations.Nullable;

public class SnapShotRemoteComponent {
    private final int myId;
    private boolean myTopLevel;
    private final String myClassName;
    private final String myLayoutManager;
    private final String myText;
    private SnapShotRemoteComponent[] myChildren = null;

    public SnapShotRemoteComponent(int id, String className, String layoutManager, String text) {
        this.myId = id;
        this.myClassName = className;
        this.myLayoutManager = layoutManager;
        this.myText = text;
    }

    public SnapShotRemoteComponent(String line, boolean topLevel) {
        String[] strings = line.trim().split(";", 4);
        this.myId = Integer.parseInt(strings[0]);
        this.myClassName = strings[1];
        this.myLayoutManager = strings[2];
        this.myText = strings[3];
        this.myTopLevel = topLevel;
    }

    public int getId() {
        return this.myId;
    }

    public boolean isTopLevel() {
        return this.myTopLevel;
    }

    public String getClassName() {
        return this.myClassName;
    }

    public String getText() {
        return this.myText;
    }

    public String getLayoutManager() {
        return this.myLayoutManager;
    }

    @Nullable
    public SnapShotRemoteComponent[] getChildren() {
        return this.myChildren;
    }

    public void setChildren(SnapShotRemoteComponent[] children) {
        this.myChildren = children;
    }

    public String toProtocolString() {
        return this.myId + ";" + this.myClassName + ";" + this.myLayoutManager + ";" + this.myText;
    }
}

