/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.model;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.configurations.ConfigurationUtil;
import com.intellij.ide.util.ClassFilter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.Arrays;

public class TestClassFilter
implements ClassFilter.ClassFilterWithScope {
    public static final String GUICE_INJECTION = "com.google.inject.Inject";
    public static final String GUICE = "org.testng.annotations.Guice";
    public static final String FACTORY_INJECTION = "org.testng.annotations.Factory";
    private final GlobalSearchScope scope;
    private final Project project;
    private final boolean includeConfig;
    private final boolean checkClassCanBeInstantiated;

    public TestClassFilter(GlobalSearchScope scope, Project project, boolean includeConfig) {
        this(scope, project, includeConfig, false);
    }

    public TestClassFilter(GlobalSearchScope scope, Project project, boolean includeConfig, boolean checkClassCanBeInstantiated) {
        this.scope = scope;
        this.project = project;
        this.includeConfig = includeConfig;
        this.checkClassCanBeInstantiated = checkClassCanBeInstantiated;
    }

    public TestClassFilter intersectionWith(GlobalSearchScope scope) {
        return new TestClassFilter(this.scope.intersectWith(scope), this.project, this.includeConfig, this.checkClassCanBeInstantiated);
    }

    public boolean isAccepted(final PsiClass psiClass) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (!ConfigurationUtil.PUBLIC_INSTANTIATABLE_CLASS.value((Object)psiClass)) {
                    return false;
                }
                boolean hasTest = TestNGUtil.hasTest((PsiModifierListOwner)psiClass);
                if (hasTest) {
                    PsiMethod[] constructors;
                    if (TestClassFilter.this.checkClassCanBeInstantiated && (constructors = psiClass.getConstructors()).length > 0) {
                        boolean canBeInstantiated = false;
                        for (PsiMethod constructor : constructors) {
                            if (constructor.getParameterList().getParametersCount() == 0) {
                                canBeInstantiated = true;
                                break;
                            }
                            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)constructor, Arrays.asList(TestClassFilter.GUICE_INJECTION, TestClassFilter.FACTORY_INJECTION), (boolean)true)) continue;
                            canBeInstantiated = true;
                            break;
                        }
                        if (!canBeInstantiated && !AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)TestClassFilter.GUICE, (boolean)false)) {
                            return false;
                        }
                    }
                    return true;
                }
                return TestClassFilter.this.includeConfig && TestNGUtil.hasConfig((PsiModifierListOwner)psiClass, TestNGUtil.CONFIG_ANNOTATIONS_FQN_NO_TEST_LEVEL);
            }
        });
    }

    public Project getProject() {
        return this.project;
    }

    public GlobalSearchScope getScope() {
        return this.scope;
    }
}

