/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.model;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.remote.strprotocol.TestResultMessage;

public class TestProxy
extends AbstractTestProxy {
    @NonNls
    public static final Pattern COMPARISION_PATTERN = Pattern.compile("(.*)expected same with:\\<(.*)\\> but was:\\<(.*)\\>.*", 32);
    @NonNls
    public static final Pattern EXPECTED_BUT_WAS_PATTERN = Pattern.compile("(.*)expected:\\<(.*)\\> but was:\\<(.*)\\>.*", 32);
    @NonNls
    public static final Pattern EXPECTED_BUT_WAS_SET_PATTERN = Pattern.compile("(.*)expected \\[(.*)\\] but got \\[(.*)\\].*", 32);
    @NonNls
    public static final Pattern EXPECTED_NOT_SAME_BUT_WAS_PATTERN = Pattern.compile("(.*)expected not same with:\\<(.*)\\> but was same:\\<(.*)\\>.*", 32);
    @NonNls
    public static final Pattern EXPECTED_BUT_FOUND_PATTERN = Pattern.compile("(.*)expected \\[(.*)\\] but found \\[(.*)\\].*", 32);
    @NonNls
    public static final Pattern EXPECTED_BUT_WAS_HAMCREST_PATTERN = Pattern.compile("(.*)\nExpected: .*?\"(.*)\"\n\\s*but: .*?\"(.*)\".*", 32);
    private final List<TestProxy> results = new ArrayList<TestProxy>();
    private TestResultMessage resultMessage;
    private String name;
    private TestProxy parent;
    private SmartPsiElementPointer psiElement;
    private boolean inProgress;
    private boolean myTearDownFailure;
    private DiffHyperlink myHyperlink;

    public TestProxy() {
    }

    public TestProxy(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isConfig() {
        return false;
    }

    @Nullable
    public PsiElement getPsiElement() {
        return this.psiElement != null ? this.psiElement.getElement() : null;
    }

    public void setPsiElement(PsiElement psiElement) {
        if (psiElement != null) {
            Project project = psiElement.getProject();
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            this.psiElement = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(psiElement);
        } else {
            this.psiElement = null;
        }
    }

    public boolean isResult() {
        return this.resultMessage != null;
    }

    public List<AbstractTestProxy> getResults(Filter filter) {
        return filter.select(this.results);
    }

    public List<TestProxy> getChildren() {
        return this.results;
    }

    public TestResultMessage getResultMessage() {
        return this.resultMessage;
    }

    public void setResultMessage(final TestResultMessage resultMessage) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiClass psiClass = (PsiClass)TestProxy.this.getParent().getPsiElement();
                if (psiClass != null) {
                    PsiMethod[] methods;
                    for (PsiMethod method : methods = psiClass.getAllMethods()) {
                        if (!method.getName().equals(resultMessage.getMethod())) continue;
                        TestProxy.this.setPsiElement((PsiElement)method);
                        break;
                    }
                }
            }
        });
        for (TestProxy current = this; current != null; current = current.getParent()) {
            current.inProgress = resultMessage.getResult() == 1016;
        }
        if (this.resultMessage == null || this.resultMessage.getResult() == 1016) {
            this.resultMessage = resultMessage;
            PsiElement psiElement = this.getPsiElement();
            this.name = TestProxy.toDisplayText(resultMessage, psiElement != null ? psiElement.getProject() : null);
        }
    }

    public boolean isInProgress() {
        TestProxy parentProxy = this.getParent();
        return (parentProxy == null || parentProxy.isInProgress()) && this.inProgress;
    }

    public boolean isDefect() {
        return this.isNotPassed();
    }

    public boolean shouldRun() {
        return true;
    }

    public int getMagnitude() {
        return -1;
    }

    public boolean isLeaf() {
        return this.isResult();
    }

    public boolean isPassed() {
        return !this.isNotPassed();
    }

    public Location getLocation(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/theoryinpractice/testng/model/TestProxy", "getLocation"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/theoryinpractice/testng/model/TestProxy", "getLocation"));
        }
        if (this.psiElement == null) {
            return null;
        }
        PsiElement element = this.psiElement.getElement();
        if (element == null) {
            return null;
        }
        return new PsiLocation(project, element);
    }

    @Nullable
    public Navigatable getDescriptor(@Nullable Location location, @NotNull TestConsoleProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/theoryinpractice/testng/model/TestProxy", "getDescriptor"));
        }
        if (location == null) {
            return null;
        }
        return EditSourceUtil.getDescriptor((PsiElement)location.getPsiElement());
    }

    public String toString() {
        return this.name + ' ' + this.results;
    }

    public void addChild(TestProxy proxy) {
        this.results.add(proxy);
        proxy.setParent(this);
        proxy.setPrinter(this.myPrinter);
        this.addLast((Printable)proxy);
    }

    public void setParent(TestProxy parent) {
        this.parent = parent;
    }

    public TestProxy getParent() {
        return this.parent;
    }

    public boolean isNotPassed() {
        if (this.resultNotPassed()) {
            return true;
        }
        if (this.resultMessage == null && this.results.size() == 0) {
            return true;
        }
        for (TestProxy child : this.results) {
            if (!child.isNotPassed()) continue;
            return true;
        }
        return false;
    }

    private boolean resultNotPassed() {
        return this.resultMessage != null && this.resultMessage.getResult() != 1001;
    }

    public List<TestProxy> getAllTests() {
        ArrayList<TestProxy> total = new ArrayList<TestProxy>();
        total.add(this);
        for (TestProxy child : this.results) {
            total.addAll(child.getAllTests());
        }
        return total;
    }

    public int getChildCount() {
        return this.results.size();
    }

    public TestProxy getChildAt(int i) {
        return this.results.get(i);
    }

    public TestProxy getFirstDefect() {
        for (TestProxy child : this.results) {
            if (child.isNotPassed() && child.isResult()) {
                return child;
            }
            TestProxy firstDefect = child.getFirstDefect();
            if (firstDefect == null) continue;
            return firstDefect;
        }
        return null;
    }

    public boolean isInterrupted() {
        return !this.isInProgress() && this.inProgress;
    }

    public boolean hasPassedTests() {
        return this.isPassed();
    }

    public boolean isIgnored() {
        return this.resultMessage != null && 1003 == this.resultMessage.getResult();
    }

    public boolean isTearDownFailure() {
        for (TestProxy result : this.results) {
            if (!result.isTearDownFailure()) continue;
            return true;
        }
        return this.myTearDownFailure;
    }

    public void setTearDownFailure(boolean tearDownFailure) {
        this.myTearDownFailure = tearDownFailure;
    }

    public void appendStacktrace(TestResultMessage result) {
        if (result.getResult() == 1001 && Registry.is((String)"testng.skip.expected.exceptions")) {
            return;
        }
        String stackTrace = result.getStackTrace();
        if (stackTrace != null) {
            List<Printable> printables = TestProxy.getPrintables(result);
            for (Printable printable : printables) {
                if (this.myHyperlink == null && printable instanceof DiffHyperlink) {
                    this.myHyperlink = (DiffHyperlink)printable;
                }
                this.addLast(printable);
            }
        }
    }

    public Long getDuration() {
        TestResultMessage message = this.getResultMessage();
        if (message != null) {
            return message.getEndMillis() - message.getStartMillis();
        }
        long duration = 0L;
        for (TestProxy testProxy : this.getChildren()) {
            Long d = testProxy.getDuration();
            duration += d == null ? 0L : d;
        }
        return duration;
    }

    public boolean shouldSkipRootNodeForExport() {
        return true;
    }

    public DiffHyperlink getDiffViewerProvider() {
        if (this.myHyperlink == null) {
            for (TestProxy proxy : this.getChildren()) {
                DiffHyperlink provider;
                if (!proxy.isDefect() || (provider = proxy.getDiffViewerProvider()) == null) continue;
                return provider;
            }
            return null;
        }
        return this.myHyperlink;
    }

    private static String trimStackTrace(String stackTrace) {
        String[] lines = stackTrace.split("\n");
        StringBuilder builder = new StringBuilder();
        if (lines.length > 0) {
            int i;
            for (i = lines.length - 1; i >= 0; --i) {
                int startIndex = lines[i].indexOf(97) + 3;
                if (lines[i].length() <= 4 || !lines[i].startsWith("org.testng.", startIndex) && !lines[i].startsWith("org.junit.", startIndex) && !lines[i].startsWith("sun.reflect.DelegatingMethodAccessorImpl", startIndex) && !lines[i].startsWith("sun.reflect.NativeMethodAccessorImpl", startIndex) && !lines[i].startsWith("java.lang.reflect.Method", startIndex) && !lines[i].startsWith("com.intellij.rt.execution.application.AppMain", startIndex)) break;
            }
            for (int j = 0; j <= i; ++j) {
                builder.append(lines[j]);
                builder.append('\n');
            }
        }
        return builder.toString();
    }

    private static List<Printable> getPrintables(TestResultMessage result) {
        ArrayList<Printable> printables;
        String s = TestProxy.trimStackTrace(result.getStackTrace());
        if (TestProxy.appendDiffChuncks(result, s, printables = new ArrayList<Printable>(), COMPARISION_PATTERN)) {
            return printables;
        }
        if (TestProxy.appendDiffChuncks(result, s, printables, EXPECTED_BUT_WAS_PATTERN)) {
            return printables;
        }
        if (TestProxy.appendDiffChuncks(result, s, printables, EXPECTED_BUT_WAS_SET_PATTERN)) {
            return printables;
        }
        if (TestProxy.appendDiffChuncks(result, s, printables, EXPECTED_NOT_SAME_BUT_WAS_PATTERN)) {
            return printables;
        }
        if (TestProxy.appendDiffChuncks(result, s, printables, EXPECTED_BUT_FOUND_PATTERN)) {
            return printables;
        }
        if (TestProxy.appendDiffChuncks(result, s, printables, EXPECTED_BUT_WAS_HAMCREST_PATTERN)) {
            return printables;
        }
        printables.add(new Chunk(s, ConsoleViewContentType.ERROR_OUTPUT));
        return printables;
    }

    private static boolean appendDiffChuncks(final TestResultMessage result, String s, List<Printable> printables, Pattern pattern) {
        Matcher matcher = pattern.matcher(s);
        if (matcher.matches()) {
            printables.add(new Chunk(matcher.group(1), ConsoleViewContentType.ERROR_OUTPUT));
            DiffHyperlink link = new DiffHyperlink(matcher.group(2), matcher.group(3), null){

                protected String getTitle() {
                    return result.getTestClass() + '#' + result.getMethod() + "() failed";
                }
            };
            printables.add((Printable)link);
            printables.add(new Chunk(TestProxy.trimStackTrace(s.substring(matcher.end(3) + 1)), ConsoleViewContentType.ERROR_OUTPUT));
            return true;
        }
        return false;
    }

    public static String toDisplayText(TestResultMessage message, Project project) {
        String testDescription;
        String name = message.getName();
        if (project != null && Comparing.strEqual((String)name, (String)project.getName())) {
            name = message.getMethod();
        }
        String mainNamePart = name;
        String[] parameters = message.getParameters();
        if (parameters != null && parameters.length > 0) {
            String[] parameterTypes = message.getParameterTypes();
            name = name + " (";
            for (int i = 0; i < parameters.length; ++i) {
                if (i > 0) {
                    name = name + ", ";
                }
                name = "java.lang.String".equals(parameterTypes[i]) && !"null".equals(parameters[i]) && !"\"\"".equals(parameters[i]) ? name + "\"" + parameters[i] + "\"" : name + parameters[i];
            }
            name = name + ")";
        }
        if ((testDescription = message.getTestDescription()) != null && !Comparing.strEqual((String)testDescription, (String)mainNamePart)) {
            name = name + " [" + testDescription + "]";
        }
        return name;
    }

    public static class Chunk
    implements Printable {
        public String text;
        public ConsoleViewContentType contentType;

        public void printOn(Printer printer) {
            printer.print(this.text, this.contentType);
        }

        public Chunk(String text, ConsoleViewContentType contentType) {
            this.text = text;
            this.contentType = contentType;
        }

        public String toString() {
            return this.text;
        }
    }
}

