/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.controllers.FetchedImage;
import com.android.tools.idea.editors.gfxtrace.rpc.Binary;
import com.android.tools.idea.editors.gfxtrace.rpc.CaptureId;
import com.android.tools.idea.editors.gfxtrace.rpc.Client;
import com.android.tools.idea.editors.gfxtrace.rpc.DeviceId;
import com.android.tools.idea.editors.gfxtrace.rpc.ImageInfo;
import com.android.tools.idea.editors.gfxtrace.rpc.ImageInfoId;
import com.android.tools.idea.editors.gfxtrace.rpc.RenderSettings;
import com.android.tools.rpclib.rpccore.RpcException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageFetcher {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ImageFetcher.class);
    @NotNull
    private Client myClient;
    private DeviceId myDeviceId;
    private CaptureId myCaptureId;
    private Integer myContextId;

    public ImageFetcher(@NotNull Client client) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/idea/editors/gfxtrace/controllers/ImageFetcher", "<init>"));
        }
        this.myClient = client;
    }

    public void prepareFetch(@NotNull DeviceId deviceId, @NotNull CaptureId captureId, @NotNull Integer contextId) {
        if (deviceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceId", "com/android/tools/idea/editors/gfxtrace/controllers/ImageFetcher", "prepareFetch"));
        }
        if (captureId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captureId", "com/android/tools/idea/editors/gfxtrace/controllers/ImageFetcher", "prepareFetch"));
        }
        if (contextId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextId", "com/android/tools/idea/editors/gfxtrace/controllers/ImageFetcher", "prepareFetch"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myDeviceId = deviceId;
        this.myCaptureId = captureId;
        this.myContextId = contextId;
    }

    @Nullable
    public ImageFetchHandle queueColorImage(long atomId, RenderSettings settings) {
        try {
            return new ImageFetchHandle(this.myClient.GetFramebufferColor(this.myDeviceId, this.myCaptureId, this.myContextId, atomId, settings).get());
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        catch (RpcException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @Nullable
    public ImageFetchHandle queueDepthImage(long atomId) {
        try {
            return new ImageFetchHandle(this.myClient.GetFramebufferDepth(this.myDeviceId, this.myCaptureId, this.myContextId, atomId).get());
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        catch (RpcException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @Nullable
    public FetchedImage resolveImage(@NotNull ImageFetchHandle handle) {
        if (handle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handle", "com/android/tools/idea/editors/gfxtrace/controllers/ImageFetcher", "resolveImage"));
        }
        try {
            ImageInfo imageInfo = handle.getImageInfo();
            if (imageInfo == null) {
                imageInfo = this.myClient.ResolveImageInfo(handle.getImageInfoId()).get();
            }
            handle.setImageInfo(imageInfo);
            Binary binary = handle.getBinary();
            if (binary == null) {
                binary = this.myClient.ResolveBinary(imageInfo.getData()).get();
                handle.setBinary(binary);
            }
            handle.setBinary(binary);
            return new FetchedImage(handle.getImageInfo(), binary);
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
        catch (RpcException e) {
            LOG.error((Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    public static class ImageFetchHandle {
        @NotNull
        private ImageInfoId myImageInfoId;
        private ImageInfo myImageInfo;
        private Binary myBinary;

        private ImageFetchHandle(@NotNull ImageInfoId imageInfoId) {
            if (imageInfoId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageInfoId", "com/android/tools/idea/editors/gfxtrace/controllers/ImageFetcher$ImageFetchHandle", "<init>"));
            }
            this.myImageInfoId = imageInfoId;
        }

        public ImageInfo getImageInfo() {
            return this.myImageInfo;
        }

        public void setImageInfo(@NotNull ImageInfo imageInfo) {
            if (imageInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageInfo", "com/android/tools/idea/editors/gfxtrace/controllers/ImageFetcher$ImageFetchHandle", "setImageInfo"));
            }
            this.myImageInfo = imageInfo;
        }

        public Binary getBinary() {
            return this.myBinary;
        }

        public void setBinary(@NotNull Binary binary) {
            if (binary == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binary", "com/android/tools/idea/editors/gfxtrace/controllers/ImageFetcher$ImageFetchHandle", "setBinary"));
            }
            this.myBinary = binary;
        }

        @NotNull
        private ImageInfoId getImageInfoId() {
            ImageInfoId imageInfoId = this.myImageInfoId;
            if (imageInfoId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/controllers/ImageFetcher$ImageFetchHandle", "getImageInfoId"));
            }
            return imageInfoId;
        }
    }
}

