/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof;

import com.android.tools.idea.editors.hprof.HprofEditor;
import com.android.tools.idea.editors.hprof.tables.ClassesTreeView;
import com.android.tools.idea.editors.hprof.tables.InstanceReferenceTree;
import com.android.tools.idea.editors.hprof.tables.InstancesTree;
import com.android.tools.idea.editors.hprof.tables.SelectionModel;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Snapshot;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HprofViewPanel
implements Disposable {
    private static final int DIVIDER_WIDTH = 4;
    @NotNull
    private JPanel myContainer;
    @NotNull
    private SelectionModel mySelectionModel;

    public HprofViewPanel(@NotNull Project project, @NotNull HprofEditor editor, final @NotNull Snapshot snapshot) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/hprof/HprofViewPanel", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/hprof/HprofViewPanel", "<init>"));
        }
        if (snapshot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "snapshot", "com/android/tools/idea/editors/hprof/HprofViewPanel", "<init>"));
        }
        JBPanel treePanel = new JBPanel((LayoutManager)new BorderLayout());
        treePanel.setBackground(JBColor.background());
        assert (snapshot.getHeaps().size() > 0);
        Heap currentHeap = null;
        for (Heap heap : snapshot.getHeaps()) {
            if ("app".equals(heap.getName())) {
                currentHeap = heap;
                break;
            }
            if (currentHeap != null) continue;
            currentHeap = heap;
        }
        if (currentHeap == null) {
            editor.setInvalid();
            return;
        }
        this.mySelectionModel = new SelectionModel(currentHeap);
        InstanceReferenceTree referenceTree = new InstanceReferenceTree(this.mySelectionModel);
        treePanel.add((Component)referenceTree.getComponent(), (Object)"Center");
        InstancesTree instancesTree = new InstancesTree(project, this.mySelectionModel);
        ClassesTreeView classesTreeView = new ClassesTreeView(this.mySelectionModel);
        JBSplitter splitter = HprofViewPanel.createNavigationSplitter(classesTreeView.getComponent(), instancesTree.getComponent());
        JBPanel classPanel = new JBPanel((LayoutManager)new BorderLayout());
        classPanel.add((Component)splitter, (Object)"Center");
        DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{new ComboBoxAction(){

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                DefaultActionGroup group = new DefaultActionGroup();
                for (final Heap heap : snapshot.getHeaps()) {
                    if ("default".equals(heap.getName()) && heap.getClasses().isEmpty() && heap.getInstances().isEmpty()) continue;
                    group.add(new AnAction(heap.getName() + " heap"){

                        public void actionPerformed(AnActionEvent e) {
                            HprofViewPanel.this.mySelectionModel.setHeap(heap);
                        }
                    });
                }
                DefaultActionGroup defaultActionGroup = group;
                if (defaultActionGroup == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/HprofViewPanel$1", "createPopupActionGroup"));
                }
                return defaultActionGroup;
            }

            public void update(AnActionEvent e) {
                super.update(e);
                this.getTemplatePresentation().setText(HprofViewPanel.this.mySelectionModel.getHeap().getName() + " heap");
                e.getPresentation().setText(HprofViewPanel.this.mySelectionModel.getHeap().getName() + " heap");
            }
        }});
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        classPanel.add((Component)toolbar.getComponent(), (Object)"North");
        JBSplitter mainSplitter = new JBSplitter(true);
        mainSplitter.setFirstComponent((JComponent)classPanel);
        mainSplitter.setSecondComponent((JComponent)treePanel);
        mainSplitter.setDividerWidth(4);
        this.myContainer = new JPanel(new BorderLayout());
        this.myContainer.add((Component)mainSplitter);
    }

    @NotNull
    public static JBSplitter createNavigationSplitter(@Nullable JComponent leftPanelContents, @Nullable JComponent rightPanelContents) {
        JBPanel navigationPanel = new JBPanel((LayoutManager)new BorderLayout());
        navigationPanel.setBackground(JBColor.background());
        if (leftPanelContents != null) {
            navigationPanel.add((Component)leftPanelContents, (Object)"Center");
        }
        JBPanel contextInformationPanel = new JBPanel((LayoutManager)new BorderLayout());
        contextInformationPanel.setBackground(JBColor.background());
        if (rightPanelContents != null) {
            contextInformationPanel.add((Component)rightPanelContents, (Object)"Center");
        }
        JBSplitter navigationSplitter = new JBSplitter(false);
        navigationSplitter.setFirstComponent((JComponent)navigationPanel);
        navigationSplitter.setSecondComponent((JComponent)contextInformationPanel);
        navigationSplitter.setDividerWidth(4);
        JBSplitter jBSplitter = navigationSplitter;
        if (jBSplitter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/HprofViewPanel", "createNavigationSplitter"));
        }
        return jBSplitter;
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myContainer;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/HprofViewPanel", "getComponent"));
        }
        return jPanel;
    }

    public void dispose() {
    }
}

