/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation;

import com.android.annotations.NonNull;
import com.android.tools.idea.editors.navigation.Event;
import com.android.tools.idea.editors.navigation.Listener;
import com.android.tools.idea.editors.navigation.SelectionModel;
import com.intellij.ui.JBColor;
import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class Inspector {
    public final JPanel container = new JPanel(new BorderLayout());
    public final SelectionModel selectionModel;

    public Inspector(SelectionModel selectionModel) {
        this.container.setBackground((Color)JBColor.WHITE);
        this.selectionModel = selectionModel;
        this.selectionModel.listeners.add(new Listener<Event>(){

            @Override
            public void notify(@NonNull Event event) {
                if (event == SelectionModel.SELECTION_UPDATED) {
                    Inspector.this.selectionModel.getSelection().configureInspector(Inspector.this);
                }
            }
        });
    }

    public void setInspectorComponent(JComponent c) {
        this.container.removeAll();
        this.container.add(c);
        this.container.revalidate();
        this.container.repaint();
    }
}

