/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.android;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.customizer.AbstractContentRootModuleCustomizer;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.variant.view.BuildVariantModuleCustomizer;
import com.google.common.collect.Lists;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ContentRootModuleCustomizer
extends AbstractContentRootModuleCustomizer<IdeaAndroidProject>
implements BuildVariantModuleCustomizer<IdeaAndroidProject> {
    private static final String[] EXCLUDED_INTERMEDIATE_FOLDER_NAMES = new String[]{"assets", "bundles", "classes", "coverage-instrumented-classes", "dependency-cache", "dex-cache", "dex", "incremental", "jacoco", "javaResources", "libs", "lint", "manifests", "ndk", "pre-dexed", "proguard", "res", "rs", "symbols"};
    @NotNull
    public static final List<String> EXCLUDED_OUTPUT_FOLDER_NAMES = Lists.newArrayList((Object[])new String[]{"outputs"});

    @Override
    @NotNull
    protected Collection<ContentEntry> findOrCreateContentEntries(@NotNull ModifiableRootModel model, @NotNull IdeaAndroidProject androidProject) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "findOrCreateContentEntries"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "findOrCreateContentEntries"));
        }
        ArrayList contentEntries = Lists.newArrayList((Object[])new ContentEntry[]{model.addContentEntry(androidProject.getRootDir())});
        File buildFolderPath = androidProject.getDelegate().getBuildFolder();
        if (!FileUtil.isAncestor((File)androidProject.getRootDirPath(), (File)buildFolderPath, (boolean)false)) {
            contentEntries.add(model.addContentEntry(FilePaths.pathToIdeaUrl(buildFolderPath)));
        }
        ArrayList arrayList = contentEntries;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "findOrCreateContentEntries"));
        }
        return arrayList;
    }

    @Override
    protected void setUpContentEntries(@NotNull ModifiableRootModel ideaModuleModel, @NotNull Collection<ContentEntry> contentEntries, @NotNull IdeaAndroidProject androidProject, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        if (ideaModuleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaModuleModel", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "setUpContentEntries"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "setUpContentEntries"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "setUpContentEntries"));
        }
        if (orphans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orphans", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "setUpContentEntries"));
        }
        Variant selectedVariant = androidProject.getSelectedVariant();
        AndroidArtifact mainArtifact = selectedVariant.getMainArtifact();
        this.addSourceFolders(androidProject, contentEntries, (BaseArtifact)mainArtifact, false, orphans);
        BaseArtifact testArtifact = androidProject.findSelectedTestArtifact(androidProject.getSelectedVariant());
        if (testArtifact != null) {
            this.addSourceFolders(androidProject, contentEntries, testArtifact, true, orphans);
        }
        for (String flavorName : selectedVariant.getProductFlavors()) {
            ProductFlavorContainer flavor = androidProject.findProductFlavor(flavorName);
            if (flavor == null) continue;
            this.addSourceFolder(androidProject, contentEntries, flavor, orphans);
        }
        String buildTypeName = selectedVariant.getBuildType();
        BuildTypeContainer buildTypeContainer = androidProject.findBuildType(buildTypeName);
        if (buildTypeContainer != null) {
            this.addSourceFolder(androidProject, contentEntries, buildTypeContainer.getSourceProvider(), false, orphans);
            Collection<SourceProvider> testSourceProviders = androidProject.getSourceProvidersForSelectedTestArtifact(buildTypeContainer.getExtraSourceProviders());
            for (SourceProvider testSourceProvider : testSourceProviders) {
                this.addSourceFolder(androidProject, contentEntries, testSourceProvider, true, orphans);
            }
        }
        ProductFlavorContainer defaultConfig = androidProject.getDelegate().getDefaultConfig();
        this.addSourceFolder(androidProject, contentEntries, defaultConfig, orphans);
        this.addExcludedOutputFolders(contentEntries, androidProject);
    }

    private void addSourceFolders(@NotNull IdeaAndroidProject androidProject, @NotNull Collection<ContentEntry> contentEntries, @NotNull BaseArtifact androidArtifact, boolean isTest, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        SourceProvider multiFlavorSourceProvider;
        SourceProvider variantSourceProvider;
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolders"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolders"));
        }
        if (androidArtifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidArtifact", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolders"));
        }
        if (orphans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orphans", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolders"));
        }
        if (androidArtifact instanceof AndroidArtifact) {
            this.addGeneratedSourceFolder(androidProject, contentEntries, (AndroidArtifact)androidArtifact, isTest, orphans);
        }
        if ((variantSourceProvider = androidArtifact.getVariantSourceProvider()) != null) {
            this.addSourceFolder(androidProject, contentEntries, variantSourceProvider, isTest, orphans);
        }
        if ((multiFlavorSourceProvider = androidArtifact.getMultiFlavorSourceProvider()) != null) {
            this.addSourceFolder(androidProject, contentEntries, multiFlavorSourceProvider, isTest, orphans);
        }
    }

    private void addGeneratedSourceFolder(@NotNull IdeaAndroidProject androidProject, @NotNull Collection<ContentEntry> contentEntries, @NotNull AndroidArtifact androidArtifact, boolean isTest, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addGeneratedSourceFolder"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addGeneratedSourceFolder"));
        }
        if (androidArtifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidArtifact", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addGeneratedSourceFolder"));
        }
        if (orphans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orphans", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addGeneratedSourceFolder"));
        }
        JpsModuleSourceRootType sourceType = ContentRootModuleCustomizer.getSourceType(isTest);
        this.addSourceFolders(androidProject, contentEntries, androidArtifact.getGeneratedSourceFolders(), sourceType, true, orphans);
        sourceType = ContentRootModuleCustomizer.getResourceSourceType(isTest);
        this.addSourceFolders(androidProject, contentEntries, androidArtifact.getGeneratedResourceFolders(), sourceType, true, orphans);
    }

    private void addSourceFolder(@NotNull IdeaAndroidProject androidProject, @NotNull Collection<ContentEntry> contentEntries, @NotNull ProductFlavorContainer flavor, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolder"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolder"));
        }
        if (flavor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavor", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolder"));
        }
        if (orphans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orphans", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolder"));
        }
        this.addSourceFolder(androidProject, contentEntries, flavor.getSourceProvider(), false, orphans);
        Collection<SourceProvider> testSourceProviders = androidProject.getSourceProvidersForSelectedTestArtifact(flavor.getExtraSourceProviders());
        for (SourceProvider sourceProvider : testSourceProviders) {
            this.addSourceFolder(androidProject, contentEntries, sourceProvider, true, orphans);
        }
    }

    private void addSourceFolder(@NotNull IdeaAndroidProject androidProject, @NotNull Collection<ContentEntry> contentEntries, @NotNull SourceProvider sourceProvider, boolean isTest, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolder"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolder"));
        }
        if (sourceProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceProvider", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolder"));
        }
        if (orphans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orphans", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolder"));
        }
        JpsModuleSourceRootType sourceType = ContentRootModuleCustomizer.getResourceSourceType(isTest);
        this.addSourceFolders(androidProject, contentEntries, sourceProvider.getResDirectories(), sourceType, false, orphans);
        this.addSourceFolders(androidProject, contentEntries, sourceProvider.getResourcesDirectories(), sourceType, false, orphans);
        this.addSourceFolders(androidProject, contentEntries, sourceProvider.getAssetsDirectories(), sourceType, false, orphans);
        sourceType = ContentRootModuleCustomizer.getSourceType(isTest);
        this.addSourceFolders(androidProject, contentEntries, sourceProvider.getAidlDirectories(), sourceType, false, orphans);
        this.addSourceFolders(androidProject, contentEntries, sourceProvider.getJavaDirectories(), sourceType, false, orphans);
        this.addSourceFolders(androidProject, contentEntries, sourceProvider.getCDirectories(), sourceType, false, orphans);
        this.addSourceFolders(androidProject, contentEntries, sourceProvider.getCppDirectories(), sourceType, false, orphans);
        this.addSourceFolders(androidProject, contentEntries, sourceProvider.getRenderscriptDirectories(), sourceType, false, orphans);
    }

    @NotNull
    private static JpsModuleSourceRootType getResourceSourceType(boolean isTest) {
        JavaResourceRootType javaResourceRootType = isTest ? JavaResourceRootType.TEST_RESOURCE : JavaResourceRootType.RESOURCE;
        if (javaResourceRootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "getResourceSourceType"));
        }
        return javaResourceRootType;
    }

    @NotNull
    private static JpsModuleSourceRootType getSourceType(boolean isTest) {
        JavaSourceRootType javaSourceRootType = isTest ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        if (javaSourceRootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "getSourceType"));
        }
        return javaSourceRootType;
    }

    private void addSourceFolders(@NotNull IdeaAndroidProject androidProject, @NotNull Collection<ContentEntry> contentEntries, @NotNull Collection<File> folderPaths, @NotNull JpsModuleSourceRootType type, boolean generated, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolders"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolders"));
        }
        if (folderPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderPaths", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolders"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolders"));
        }
        if (orphans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orphans", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addSourceFolders"));
        }
        for (File folderPath : folderPaths) {
            if (generated && !ContentRootModuleCustomizer.isGeneratedAtCorrectLocation(folderPath, androidProject.getDelegate())) {
                androidProject.registerExtraGeneratedSourceFolder(folderPath);
            }
            this.addSourceFolder(contentEntries, folderPath, type, generated, orphans);
        }
    }

    private static boolean isGeneratedAtCorrectLocation(@NotNull File folderPath, @NotNull AndroidProject project) {
        if (folderPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderPath", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "isGeneratedAtCorrectLocation"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "isGeneratedAtCorrectLocation"));
        }
        File generatedFolderPath = new File(project.getBuildFolder(), "generated");
        return FileUtil.isAncestor((File)generatedFolderPath, (File)folderPath, (boolean)false);
    }

    private void addExcludedOutputFolders(@NotNull Collection<ContentEntry> contentEntries, @NotNull IdeaAndroidProject androidProject) {
        File[] children;
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addExcludedOutputFolders"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "addExcludedOutputFolders"));
        }
        File buildFolderPath = androidProject.getDelegate().getBuildFolder();
        ContentEntry parentContentEntry = FilePaths.findParentContentEntry(buildFolderPath, contentEntries);
        if (parentContentEntry == null) {
            return;
        }
        for (String folderName : EXCLUDED_OUTPUT_FOLDER_NAMES) {
            File excludedFolderPath = new File(buildFolderPath, folderName);
            this.addExcludedFolder(parentContentEntry, excludedFolderPath);
        }
        for (File child : children = FileUtil.notNullize((File[])buildFolderPath.listFiles())) {
            if (!androidProject.shouldManuallyExclude(child)) continue;
            this.addExcludedFolder(parentContentEntry, child);
        }
    }

    @Override
    @NotNull
    public ProjectSystemId getProjectSystemId() {
        ProjectSystemId projectSystemId = GradleUtil.GRADLE_SYSTEM_ID;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "getProjectSystemId"));
        }
        return projectSystemId;
    }

    @Override
    @NotNull
    public Class<IdeaAndroidProject> getSupportedModelType() {
        if (IdeaAndroidProject.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/android/ContentRootModuleCustomizer", "getSupportedModelType"));
        }
        return IdeaAndroidProject.class;
    }

    static {
        for (String name : EXCLUDED_INTERMEDIATE_FOLDER_NAMES) {
            EXCLUDED_OUTPUT_FOLDER_NAMES.add(FileUtil.join((String[])new String[]{"intermediates", name}));
        }
    }
}

