/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.builder.model.AndroidProject;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import java.text.Collator;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleTypeComparator
implements Comparator<Module> {
    public static final ModuleTypeComparator INSTANCE = new ModuleTypeComparator();

    @Override
    public int compare(Module m1, Module m2) {
        AndroidProject p1 = GradleUtil.getAndroidProject(m1);
        AndroidProject p2 = GradleUtil.getAndroidProject(m2);
        return ModuleTypeComparator.compareModules(m1, m2, p1, p2);
    }

    @VisibleForTesting
    static int compareModules(@NotNull Module m1, @NotNull Module m2, @Nullable AndroidProject p1, @Nullable AndroidProject p2) {
        if (m1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m1", "com/android/tools/idea/gradle/util/ModuleTypeComparator", "compareModules"));
        }
        if (m2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m2", "com/android/tools/idea/gradle/util/ModuleTypeComparator", "compareModules"));
        }
        if (p1 == null && p2 == null || p1 != null && p2 != null && p1.isLibrary() == p2.isLibrary()) {
            return Collator.getInstance().compare(m1.getName(), m2.getName());
        }
        if (p1 != null) {
            if (p2 != null) {
                return !p1.isLibrary() ? -1 : 1;
            }
            return -1;
        }
        return 1;
    }
}

