/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.builder.model.AndroidProject;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.lang.databinding.DbUtil;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import java.awt.Color;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.rendering.ResourceHelper");
    private static final String STATE_NAME_PREFIX = "state_";

    public static boolean isProjectStyle(@NotNull String style) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/rendering/ResourceHelper", "isProjectStyle"));
        }
        assert (style.startsWith("@style/") || style.startsWith("@android:style/")) : style;
        return style.startsWith("@style/");
    }

    @NotNull
    public static String styleToTheme(@NotNull String style) {
        int index;
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/rendering/ResourceHelper", "styleToTheme"));
        }
        if (style.startsWith("@style/")) {
            style = style.substring("@style/".length());
        } else if (style.startsWith("@android:style/")) {
            style = style.substring("@android:style/".length());
        } else if (style.startsWith("@") && (index = style.indexOf(47)) != -1) {
            style = style.substring(index + 1);
        }
        String string = style;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper", "styleToTheme"));
        }
        return string;
    }

    public static boolean isValueBasedResourceType(@NotNull ResourceType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/rendering/ResourceHelper", "isValueBasedResourceType"));
        }
        List folderTypes = FolderTypeRelationship.getRelatedFolders((ResourceType)type);
        for (ResourceFolderType folderType : folderTypes) {
            if (folderType != ResourceFolderType.VALUES) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String getResourceName(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/ResourceHelper", "getResourceName"));
        }
        String string = LintUtils.getBaseName((String)file.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper", "getResourceName"));
        }
        return string;
    }

    @NotNull
    public static String getResourceName(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/ResourceHelper", "getResourceName"));
        }
        String string = LintUtils.getBaseName((String)file.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper", "getResourceName"));
        }
        return string;
    }

    @NotNull
    public static String getResourceUrl(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/ResourceHelper", "getResourceUrl"));
        }
        ResourceFolderType type = ResourceFolderType.getFolderType((String)file.getParent().getName());
        assert (type != null && type != ResourceFolderType.VALUES);
        String string = "@" + type.getName() + '/' + ResourceHelper.getResourceName(file);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper", "getResourceUrl"));
        }
        return string;
    }

    public static boolean isFileBasedResourceType(@NotNull ResourceType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/rendering/ResourceHelper", "isFileBasedResourceType"));
        }
        List folderTypes = FolderTypeRelationship.getRelatedFolders((ResourceType)type);
        for (ResourceFolderType folderType : folderTypes) {
            if (folderType == ResourceFolderType.VALUES) continue;
            return type != ResourceType.ID;
        }
        return false;
    }

    @Nullable
    public static ResourceFolderType getFolderType(final @Nullable PsiFile file) {
        if (file != null) {
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                return (ResourceFolderType)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ResourceFolderType>(){

                    @Nullable
                    public ResourceFolderType compute() {
                        return ResourceHelper.getFolderType(file);
                    }
                });
            }
            if (!file.isValid()) {
                return ResourceHelper.getFolderType(file.getVirtualFile());
            }
            PsiDirectory parent = file.getParent();
            if (parent != null) {
                return ResourceFolderType.getFolderType((String)parent.getName());
            }
        }
        return null;
    }

    @Nullable
    public static ResourceFolderType getFolderType(@Nullable VirtualFile file) {
        VirtualFile parent;
        if (file != null && (parent = file.getParent()) != null) {
            return ResourceFolderType.getFolderType((String)parent.getName());
        }
        return null;
    }

    @Nullable
    public static FolderConfiguration getFolderConfiguration(final @Nullable PsiFile file) {
        if (file != null) {
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                return (FolderConfiguration)ApplicationManager.getApplication().runReadAction((Computable)new Computable<FolderConfiguration>(){

                    @Nullable
                    public FolderConfiguration compute() {
                        return ResourceHelper.getFolderConfiguration(file);
                    }
                });
            }
            if (!file.isValid()) {
                return ResourceHelper.getFolderConfiguration(file.getVirtualFile());
            }
            PsiDirectory parent = file.getParent();
            if (parent != null) {
                return FolderConfiguration.getConfigForFolder((String)parent.getName());
            }
        }
        return null;
    }

    @Nullable
    public static FolderConfiguration getFolderConfiguration(@Nullable VirtualFile file) {
        VirtualFile parent;
        if (file != null && (parent = file.getParent()) != null) {
            return FolderConfiguration.getConfigForFolder((String)parent.getName());
        }
        return null;
    }

    public static List<VirtualFile> getResourceVariations(@Nullable VirtualFile file, boolean includeSelf) {
        VirtualFile resFolder;
        if (file == null) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> variations = new ArrayList<VirtualFile>();
        String name = file.getName();
        VirtualFile parent = file.getParent();
        if (parent != null && (resFolder = parent.getParent()) != null) {
            String parentName = parent.getName();
            String prefix = parentName;
            int qualifiers = prefix.indexOf(45);
            if (qualifiers != -1) {
                parentName = prefix.substring(0, qualifiers);
                prefix = prefix.substring(0, qualifiers + 1);
            } else {
                prefix = prefix + '-';
            }
            for (VirtualFile resource : resFolder.getChildren()) {
                VirtualFile variation;
                String n = resource.getName();
                if (!n.startsWith(prefix) && !n.equals(parentName) || !resource.isDirectory() || (variation = resource.findChild(name)) == null || !includeSelf && file.equals(variation)) continue;
                variations.add(variation);
            }
        }
        return variations;
    }

    public static boolean viewNeedsPackage(String fqcn) {
        return !fqcn.startsWith("android.widget.") && !fqcn.startsWith("android.view.") && !fqcn.startsWith("android.webkit.");
    }

    @Nullable
    public static Color resolveColor(@NotNull RenderResources resources, @Nullable ResourceValue color) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/rendering/ResourceHelper", "resolveColor"));
        }
        if (color != null) {
            color = resources.resolveResValue(color);
        }
        if (color == null) {
            return null;
        }
        Iterator<String> iterator = new StateListIterable(resources, color, 50, "color", false).iterator();
        if (iterator.hasNext()) {
            return ResourceHelper.parseColor(iterator.next());
        }
        return null;
    }

    @NotNull
    public static List<Color> resolveMultipleColors(@NotNull RenderResources resources, @Nullable ResourceValue color) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/rendering/ResourceHelper", "resolveMultipleColors"));
        }
        if (color != null) {
            color = resources.resolveResValue(color);
        }
        if (color == null) {
            List<Color> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper", "resolveMultipleColors"));
            }
            return list;
        }
        ArrayList<Color> result = new ArrayList<Color>();
        for (String maybeColor : new StateListIterable(resources, color, 50, "color", true)) {
            Color parsedColor;
            if (!maybeColor.startsWith("#") || (parsedColor = ResourceHelper.parseColor(maybeColor)) == null) continue;
            result.add(parsedColor);
        }
        ArrayList<Color> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper", "resolveMultipleColors"));
        }
        return arrayList;
    }

    @Nullable
    private static String findInStateList(@NotNull NodeList items, String attributeName) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/android/tools/idea/rendering/ResourceHelper", "findInStateList"));
        }
        String color = null;
        int n = items.getLength();
        for (int i = 0; i < n; ++i) {
            Element element;
            Node item = items.item(i);
            boolean hasState = false;
            if (item.getNodeType() != 1 || !(element = (Element)item).hasAttributeNS("http://schemas.android.com/apk/res/android", attributeName)) continue;
            NamedNodeMap attributes = element.getAttributes();
            int m = attributes.getLength();
            for (int j = 0; j < m; ++j) {
                Attr attribute = (Attr)attributes.item(j);
                if (!attribute.getLocalName().startsWith(STATE_NAME_PREFIX)) continue;
                hasState = true;
                break;
            }
            color = element.getAttributeNS("http://schemas.android.com/apk/res/android", attributeName);
            if (hasState) continue;
            return color;
        }
        return color;
    }

    @NotNull
    private static List<String> getAllFromStateList(@NotNull NodeList items, String attributeName) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/android/tools/idea/rendering/ResourceHelper", "getAllFromStateList"));
        }
        if (items.getLength() == 0) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper", "getAllFromStateList"));
            }
            return list;
        }
        ArrayList<String> result = new ArrayList<String>();
        int n = items.getLength();
        for (int i = 0; i < n; ++i) {
            Element element;
            String value;
            Node node = items.item(i);
            if (node.getNodeType() != 1 || Strings.isNullOrEmpty((String)(value = (element = (Element)node).getAttributeNS("http://schemas.android.com/apk/res/android", attributeName)))) continue;
            result.add(value);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper", "getAllFromStateList"));
        }
        return arrayList;
    }

    @Nullable
    public static Color parseColor(String s) {
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        if (s.charAt(0) == '#') {
            long longColor;
            try {
                longColor = Long.parseLong(s.substring(1), 16);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (s.length() == 4 || s.length() == 5) {
                long a = s.length() == 4 ? 255L : ResourceHelper.extend((longColor & 0xF000L) >> 12);
                long r = ResourceHelper.extend((longColor & 0xF00L) >> 8);
                long g = ResourceHelper.extend((longColor & 0xF0L) >> 4);
                long b = ResourceHelper.extend(longColor & 0xFL);
                longColor = a << 24 | r << 16 | g << 8 | b;
                return new Color((int)longColor, true);
            }
            if (s.length() == 7) {
                longColor |= 0xFFFFFFFFFF000000L;
            } else if (s.length() != 9) {
                return null;
            }
            return new Color((int)longColor, true);
        }
        return null;
    }

    public static String colorToString(Color color) {
        long longColor = color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
        if (color.getAlpha() != 255) {
            return String.format("#%08x", longColor |= (long)color.getAlpha() << 24);
        }
        return String.format("#%06x", longColor);
    }

    private static long extend(long nibble) {
        return nibble | nibble << 4;
    }

    @Nullable
    public static File resolveDrawable(@NotNull RenderResources resources, @Nullable ResourceValue drawable) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/rendering/ResourceHelper", "resolveDrawable"));
        }
        if (drawable != null) {
            drawable = resources.resolveResValue(drawable);
        }
        if (drawable == null) {
            return null;
        }
        Iterator<String> iterator = new StateListIterable(resources, drawable, 50, "drawable", false).iterator();
        if (iterator.hasNext()) {
            String result = iterator.next();
            File file = new File(result);
            return file.exists() ? file : null;
        }
        return null;
    }

    @Nullable
    public static File resolveLayout(@NotNull RenderResources resources, @Nullable ResourceValue layout) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/rendering/ResourceHelper", "resolveLayout"));
        }
        if (layout != null) {
            layout = resources.resolveResValue(layout);
        }
        if (layout == null) {
            return null;
        }
        String value = layout.getValue();
        for (int depth = 0; value != null && depth < 50; ++depth) {
            if (value.startsWith("@{") && (value = DbUtil.getBindingExprDefault(value)) == null) {
                return null;
            }
            if (value.startsWith("@")) {
                boolean isFramework = layout.isFramework();
                if ((layout = resources.findResValue(value, isFramework)) == null) break;
            } else {
                File file = new File(value);
                if (file.exists()) {
                    return file;
                }
                return null;
            }
            value = layout.getValue();
        }
        return null;
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public static String prependResourcePrefix(@Nullable Module module, @Nullable String name) {
        String resourcePrefix;
        IdeaAndroidProject p;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (p = facet.getIdeaAndroidProject()) != null && (resourcePrefix = LintUtils.computeResourcePrefix((AndroidProject)p.getDelegate())) != null) {
            if (name != null) {
                return name.startsWith(resourcePrefix) ? name : LintUtils.computeResourceName((String)resourcePrefix, (String)name);
            }
            return resourcePrefix;
        }
        return name;
    }

    private static class StateListIterable
    implements Iterable<String> {
        private final RenderResources myRenderResources;
        private final ResourceValue myStartValue;
        private final int myMaximumSteps;
        private final String myAttributeType;
        private final boolean myTraverseAllOptions;

        private StateListIterable(RenderResources renderResources, ResourceValue startValue, int maximumSteps, String attributeType, boolean traverseAllOptions) {
            this.myRenderResources = renderResources;
            this.myAttributeType = attributeType;
            this.myStartValue = startValue;
            this.myMaximumSteps = maximumSteps;
            this.myTraverseAllOptions = traverseAllOptions;
        }

        @Override
        public Iterator<String> iterator() {
            return new StateListIterator(this.myStartValue);
        }

        private class StateListIterator
        implements Iterator<String> {
            private int myStepsMade = 0;
            private final Queue<Pair<String, Boolean>> myQueue = new LinkedList<Pair<String, Boolean>>();
            private String myLastValue = null;

            public StateListIterator(ResourceValue value) {
                if (value == null) {
                    return;
                }
                this.myQueue.add((Pair<String, Boolean>)Pair.create((Object)value.getValue(), (Object)value.isFramework()));
                this.myLastValue = this.getNext();
            }

            private String getNext() {
                while (this.myStepsMade < StateListIterable.this.myMaximumSteps && !this.myQueue.isEmpty()) {
                    String value;
                    block10: {
                        ++this.myStepsMade;
                        Pair<String, Boolean> pair = this.myQueue.poll();
                        value = (String)pair.getFirst();
                        if (value.startsWith("@")) {
                            ResourceUrl url = ResourceUrl.parse((String)value);
                            if (url != null) {
                                boolean isFramework = (Boolean)pair.getSecond() != false || url.framework;
                                ResourceValue resValue = StateListIterable.this.myRenderResources.findResValue(value, isFramework);
                                if (resValue != null) {
                                    this.myQueue.add((Pair<String, Boolean>)Pair.create((Object)resValue.getValue(), (Object)isFramework));
                                    continue;
                                }
                            }
                        } else {
                            File file = new File(value);
                            if (file.exists() && file.getName().endsWith(".xml")) {
                                try {
                                    String xml = Files.toString((File)file, (Charset)Charsets.UTF_8);
                                    Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                                    if (document == null) break block10;
                                    NodeList items = document.getElementsByTagName("item");
                                    Boolean isFramework = (Boolean)pair.getSecond();
                                    if (StateListIterable.this.myTraverseAllOptions) {
                                        for (String nextValue : ResourceHelper.getAllFromStateList(items, StateListIterable.this.myAttributeType)) {
                                            this.myQueue.add((Pair<String, Boolean>)Pair.create((Object)nextValue, (Object)isFramework));
                                        }
                                        continue;
                                    }
                                    String nextValue = ResourceHelper.findInStateList(items, StateListIterable.this.myAttributeType);
                                    if (Strings.isNullOrEmpty((String)nextValue)) continue;
                                    this.myQueue.add((Pair<String, Boolean>)Pair.create((Object)nextValue, (Object)isFramework));
                                    continue;
                                }
                                catch (Exception e) {
                                    LOG.warn(String.format("Failed parsing state list file %1$s", file.getName()), (Throwable)e);
                                }
                            }
                        }
                    }
                    return value;
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.myLastValue != null;
            }

            @Override
            public String next() {
                if (this.myLastValue == null) {
                    throw new NoSuchElementException();
                }
                String result = this.myLastValue;
                this.myLastValue = this.getNext();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

