/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.utils.SdkUtils;
import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PrefixTemplateLoader
implements TemplateLoader {
    private String myPrefix;

    public PrefixTemplateLoader(@Nullable String prefix) {
        this.myPrefix = prefix;
    }

    public void setTemplateFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/PrefixTemplateLoader", "setTemplateFile"));
        }
        this.setTemplateParent(file.getParentFile());
    }

    public void setTemplateParent(@NotNull File parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/templates/PrefixTemplateLoader", "setTemplateParent"));
        }
        this.myPrefix = parent.getPath();
    }

    @NotNull
    public Reader getReader(@NotNull Object templateSource, @NotNull String encoding) throws IOException {
        if (templateSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateSource", "com/android/tools/idea/templates/PrefixTemplateLoader", "getReader"));
        }
        if (encoding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encoding", "com/android/tools/idea/templates/PrefixTemplateLoader", "getReader"));
        }
        InputStream stream = (InputStream)templateSource;
        InputStreamReader inputStreamReader = new InputStreamReader(stream, encoding);
        if (inputStreamReader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/PrefixTemplateLoader", "getReader"));
        }
        return inputStreamReader;
    }

    public long getLastModified(Object templateSource) {
        return 0L;
    }

    @Nullable
    public Object findTemplateSource(@NotNull String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/templates/PrefixTemplateLoader", "findTemplateSource"));
        }
        String path = this.myPrefix != null ? this.myPrefix + '/' + name : name;
        File file = new File(path);
        if (file.exists()) {
            return SdkUtils.fileToUrl((File)file).openStream();
        }
        return null;
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        ((InputStream)templateSource).close();
    }
}

