/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

public class LabelWithEditLink
extends JPanel
implements TextAccessor {
    private static final String EDIT_TEXT = "<html><a>Edit</a></html>";
    private static final String DONE_TEXT = "<html><a>Done</a></html>";
    public static final String DISPLAY = "Display";
    public static final String EDIT = "Edit";
    private JBLabel myContentLabel = new JBLabel();
    private HyperlinkLabel myEditLabel = new HyperlinkLabel();
    private CardLayout myCardLayout = new CardLayout();
    private JPanel myCardPanel = new JPanel(this.myCardLayout);
    private JTextField myEditField = new JTextField();
    private boolean myInEditMode = false;

    public LabelWithEditLink() {
        this.setLayout(new BorderLayout());
        this.myCardPanel.add(EDIT, this.myEditField);
        this.myCardPanel.add(DISPLAY, (Component)this.myContentLabel);
        this.myCardPanel.revalidate();
        this.myCardPanel.repaint();
        this.myCardLayout.show(this.myCardPanel, DISPLAY);
        this.add((Component)this.myCardPanel, "Center");
        this.add((Component)this.myEditLabel, "East");
        this.myContentLabel.setHorizontalTextPosition(4);
        this.myEditLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                    LabelWithEditLink.this.toggleEdit();
                }
            }
        });
        this.myContentLabel.setForeground((Color)JBColor.gray);
        this.setFont(UIUtil.getLabelFont());
        this.myEditLabel.setHtmlText(EDIT_TEXT);
    }

    private void toggleEdit() {
        if (this.myInEditMode) {
            this.myCardLayout.show(this.myCardPanel, DISPLAY);
            this.myEditLabel.setHtmlText(EDIT_TEXT);
            this.myContentLabel.setText(this.myEditField.getText());
        } else {
            this.myCardLayout.show(this.myCardPanel, EDIT);
            this.myEditLabel.setHtmlText(DONE_TEXT);
            this.myEditField.setText(this.myContentLabel.getText());
            this.myEditField.requestFocusInWindow();
        }
        this.myInEditMode = !this.myInEditMode;
    }

    public void setText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/wizard/LabelWithEditLink", "setText"));
        }
        this.myEditField.setText(text);
        this.myContentLabel.setText(text);
    }

    @NotNull
    public String getText() {
        if (this.myEditField.getText() != null) {
            String string = this.myEditField.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/LabelWithEditLink", "getText"));
            }
            return string;
        }
        if (this.myContentLabel.getText() != null) {
            String string = this.myContentLabel.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/LabelWithEditLink", "getText"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/LabelWithEditLink", "getText"));
        }
        return "";
    }

    @Override
    public void setFont(Font font) {
        if (font == null || this.myContentLabel == null) {
            return;
        }
        super.setFont(font);
        this.myContentLabel.setFont(font);
        float smallFontSize = font.getSize() - 1;
        if (smallFontSize <= 0.0f) {
            smallFontSize = font.getSize();
        }
        Font smallerFont = font.deriveFont(smallFontSize);
        this.myEditLabel.setFont(smallerFont);
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myEditField.getDocument();
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/LabelWithEditLink", "getDocument"));
        }
        return document;
    }
}

