/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.utils.XmlUtils;
import com.intellij.android.designer.designSurface.AndroidDesignerEditorPanel;
import com.intellij.android.designer.designSurface.RootView;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadVisualComponent;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import java.util.Locale;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

public class AndroidDesignerUtils {
    private AndroidDesignerUtils() {
    }

    @Nullable
    public static AndroidFacet getFacet(@NotNull EditableArea area) {
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/android/designer/AndroidDesignerUtils", "getFacet"));
        }
        AndroidDesignerEditorPanel panel = AndroidDesignerUtils.getPanel(area);
        if (panel != null) {
            Configuration configuration = panel.getConfiguration();
            assert (configuration != null);
            Module module = panel.getModule();
            return AndroidFacet.getInstance(module);
        }
        return null;
    }

    @Nullable
    public static RenderTask createRenderTask(@NotNull EditableArea area) {
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/android/designer/AndroidDesignerUtils", "createRenderTask"));
        }
        AndroidDesignerEditorPanel panel = AndroidDesignerUtils.getPanel(area);
        if (panel != null) {
            Configuration configuration = panel.getConfiguration();
            assert (configuration != null);
            XmlFile xmlFile = panel.getXmlFile();
            Module module = panel.getModule();
            AndroidFacet facet = AndroidFacet.getInstance(module);
            assert (facet != null);
            AndroidDesignerEditorPanel renderContext = panel;
            RenderService renderService = RenderService.get(facet);
            RenderLogger logger = renderService.createLogger();
            RenderTask task = renderService.createTask((PsiFile)xmlFile, configuration, logger, renderContext);
            assert (task != null);
            return task;
        }
        return null;
    }

    @Nullable
    public static AndroidDesignerEditorPanel getPanel(@NotNull EditableArea area) {
        Component nativeComponent;
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/android/designer/AndroidDesignerUtils", "getPanel"));
        }
        RadComponent root = area.getRootComponent();
        if (root instanceof RadVisualComponent && (nativeComponent = ((RadVisualComponent)root).getNativeComponent()) instanceof RootView) {
            return ((RootView)nativeComponent).getPanel();
        }
        return null;
    }

    public static int getDpi(@NotNull EditableArea area) {
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/android/designer/AndroidDesignerUtils", "getDpi"));
        }
        AndroidDesignerEditorPanel panel = AndroidDesignerUtils.getPanel(area);
        if (panel != null) {
            return panel.getDpi();
        }
        return 160;
    }

    public static int pxToDp(@NotNull EditableArea area, int px) {
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/android/designer/AndroidDesignerUtils", "pxToDp"));
        }
        int dpi = AndroidDesignerUtils.getDpi(area);
        return px * 160 / dpi;
    }

    @NotNull
    public static String pxToDpWithUnits(@NotNull EditableArea area, int px) {
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/android/designer/AndroidDesignerUtils", "pxToDpWithUnits"));
        }
        String string = String.format(Locale.US, "%ddp", AndroidDesignerUtils.pxToDp(area, px));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/AndroidDesignerUtils", "pxToDpWithUnits"));
        }
        return string;
    }

    public static int dpToPx(@NotNull EditableArea area, int dp) {
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/android/designer/AndroidDesignerUtils", "dpToPx"));
        }
        int dpi = AndroidDesignerUtils.getDpi(area);
        return dp * dpi / 160;
    }

    public static Dimension computePreferredSize(@NotNull EditableArea area, @NotNull RadViewComponent component, @Nullable RadComponent targetParent) {
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/android/designer/AndroidDesignerUtils", "computePreferredSize"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/AndroidDesignerUtils", "computePreferredSize"));
        }
        FeedbackLayer layer = area.getFeedbackLayer();
        Dimension size = component.getBounds((Component)layer).getSize();
        if (size.width == 0 && size.height == 0) {
            List<ViewInfo> roots;
            RenderTask task = AndroidDesignerUtils.createRenderTask(area);
            if (task != null && (roots = AndroidDesignerUtils.measureComponent(area, component, targetParent)) != null && !roots.isEmpty()) {
                ViewInfo root = roots.get(0);
                size.width = root.getRight() - root.getLeft();
                size.height = root.getBottom() - root.getTop();
                if (size.width != 0 && size.height != 0) {
                    RadComponent rootComponent;
                    if (targetParent != null) {
                        return targetParent.fromModel((Component)layer, size);
                    }
                    AndroidDesignerEditorPanel panel = AndroidDesignerUtils.getPanel(area);
                    if (panel != null && (rootComponent = panel.getRootComponent()) != null) {
                        return rootComponent.fromModel((Component)layer, size);
                    }
                    return size;
                }
            }
            size.width = 100;
            size.height = 30;
        }
        return size;
    }

    @Nullable
    public static List<ViewInfo> measureComponent(@NotNull EditableArea area, @NotNull RadViewComponent component, @Nullable RadComponent targetParent) {
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/android/designer/AndroidDesignerUtils", "measureComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/AndroidDesignerUtils", "measureComponent"));
        }
        XmlTag tag = component.getTag();
        if (tag == null) {
            String xml = null;
            PaletteItem initialPaletteItem = component.getInitialPaletteItem();
            if (initialPaletteItem != null) {
                xml = initialPaletteItem.getCreation();
            }
            if (xml == null) {
                xml = component.getCreationXml();
            }
            if (xml != null) {
                ViewInfo root;
                List<ViewInfo> roots;
                RenderTask task;
                RadViewComponent viewRoot;
                XmlTag rootTag;
                RadComponent root2;
                String widthValue = "fill_parent";
                String heightValue = "fill_parent";
                if (targetParent instanceof RadViewComponent && (xml.contains("fill_parent") || xml.contains("match_parent"))) {
                    RadViewComponent parent = (RadViewComponent)targetParent;
                    Rectangle paddedBounds = parent.getPaddedBounds();
                    if (paddedBounds.width > 0 && paddedBounds.height > 0) {
                        widthValue = Integer.toString(paddedBounds.width) + "px";
                        heightValue = Integer.toString(paddedBounds.height) + "px";
                    }
                }
                StringBuilder sb = new StringBuilder(xml.length() + 200);
                sb.append('<').append("FrameLayout").append(' ').append("xmlns:android").append("=\"").append("http://schemas.android.com/apk/res/android").append('\"');
                sb.append(' ').append("android").append(':').append("layout_width").append("=\"").append(widthValue).append('\"');
                sb.append(' ').append("android").append(':').append("layout_height").append("=\"").append(heightValue).append('\"');
                if (targetParent != null && (root2 = targetParent.getRoot()) instanceof RadViewComponent && (rootTag = (viewRoot = (RadViewComponent)root2).getTag()) != null) {
                    for (XmlAttribute attribute : rootTag.getAttributes()) {
                        String value;
                        String name = attribute.getName();
                        if (!name.startsWith("xmlns:") || "xmlns:android".equals(name) || (value = attribute.getValue()) == null || value.isEmpty()) continue;
                        sb.append(' ').append(name).append("=\"");
                        XmlUtils.appendXmlAttributeValue((StringBuilder)sb, (String)value);
                        sb.append('\"');
                    }
                }
                sb.append('>');
                sb.append(xml);
                sb.append('<').append('/').append("FrameLayout").append('>');
                Document document = XmlUtils.parseDocumentSilently((String)sb.toString(), (boolean)true);
                if (document != null && document.getDocumentElement() != null && (task = AndroidDesignerUtils.createRenderTask(area)) != null && (roots = task.measure(document.getDocumentElement())) != null && !roots.isEmpty() && (root = roots.get(0)).getClassName().equals("android.widget.FrameLayout") && !root.getChildren().isEmpty()) {
                    return root.getChildren();
                }
            }
        }
        return null;
    }
}

