/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.layout;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomExtender;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidLayoutUtil {
    private AndroidLayoutUtil() {
    }

    @NotNull
    public static List<String> getPossibleRoots(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/dom/layout/AndroidLayoutUtil", "getPossibleRoots"));
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add("view");
        result.add("merge");
        result.add("fragment");
        result.addAll(AndroidDomUtil.removeUnambiguousNames(AndroidDomExtender.getViewClassMap(facet)));
        result.remove("View");
        result.add("layout");
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/layout/AndroidLayoutUtil", "getPossibleRoots"));
        }
        return arrayList;
    }
}

