/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilteredAttributeDefinitions
implements AttributeDefinitions {
    private final AttributeDefinitions myWrappee;

    protected FilteredAttributeDefinitions(@NotNull AttributeDefinitions wrappee) {
        if (wrappee == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappee", "org/jetbrains/android/resourceManagers/FilteredAttributeDefinitions", "<init>"));
        }
        this.myWrappee = wrappee;
    }

    protected abstract boolean isAttributeAcceptable(@NotNull String var1);

    @Override
    @Nullable
    public StyleableDefinition getStyleableByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/resourceManagers/FilteredAttributeDefinitions", "getStyleableByName"));
        }
        StyleableDefinition styleable = this.myWrappee.getStyleableByName(name);
        return styleable != null ? new MyStyleableDefinition(styleable) : null;
    }

    @Override
    @NotNull
    public Set<String> getAttributeNames() {
        HashSet result = new HashSet();
        for (String name : this.myWrappee.getAttributeNames()) {
            if (!this.isAttributeAcceptable(name)) continue;
            result.add(name);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/FilteredAttributeDefinitions", "getAttributeNames"));
        }
        return hashSet;
    }

    @Override
    @Nullable
    public AttributeDefinition getAttrDefByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/resourceManagers/FilteredAttributeDefinitions", "getAttrDefByName"));
        }
        return this.isAttributeAcceptable(name) ? this.myWrappee.getAttrDefByName(name) : null;
    }

    @Override
    @Nullable
    public String getAttrGroupByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/resourceManagers/FilteredAttributeDefinitions", "getAttrGroupByName"));
        }
        return this.myWrappee.getAttrGroupByName(name);
    }

    @Override
    @NotNull
    public StyleableDefinition[] getStateStyleables() {
        StyleableDefinition[] styleables = this.myWrappee.getStateStyleables();
        StyleableDefinition[] result = new StyleableDefinition[styleables.length];
        for (int i = 0; i < styleables.length; ++i) {
            result[i] = new MyStyleableDefinition(styleables[i]);
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/FilteredAttributeDefinitions", "getStateStyleables"));
        }
        return result;
    }

    private class MyStyleableDefinition
    implements StyleableDefinition {
        private final StyleableDefinition myWrappee;

        private MyStyleableDefinition(StyleableDefinition wrappee) {
            if (wrappee == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappee", "org/jetbrains/android/resourceManagers/FilteredAttributeDefinitions$MyStyleableDefinition", "<init>"));
            }
            this.myWrappee = wrappee;
        }

        @Override
        @NotNull
        public List<StyleableDefinition> getChildren() {
            List<StyleableDefinition> styleables = this.myWrappee.getChildren();
            ArrayList<StyleableDefinition> result = new ArrayList<StyleableDefinition>(styleables.size());
            for (StyleableDefinition styleable : styleables) {
                result.add(new MyStyleableDefinition(styleable));
            }
            ArrayList<StyleableDefinition> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/FilteredAttributeDefinitions$MyStyleableDefinition", "getChildren"));
            }
            return arrayList;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myWrappee.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/FilteredAttributeDefinitions$MyStyleableDefinition", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public List<AttributeDefinition> getAttributes() {
            ArrayList<AttributeDefinition> result = new ArrayList<AttributeDefinition>();
            for (AttributeDefinition definition : this.myWrappee.getAttributes()) {
                if (!FilteredAttributeDefinitions.this.isAttributeAcceptable(definition.getName())) continue;
                result.add(definition);
            }
            ArrayList<AttributeDefinition> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/FilteredAttributeDefinitions$MyStyleableDefinition", "getAttributes"));
            }
            return arrayList;
        }
    }
}

