/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;

class JavaFxFactoryReferenceProvider
extends PsiReferenceProvider {
    JavaFxFactoryReferenceProvider() {
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFactoryReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFactoryReferenceProvider", "getReferencesByElement"));
        }
        XmlAttributeValue attributeValue = (XmlAttributeValue)element;
        PsiReference[] psiReferenceArray = new PsiReference[]{new JavaFXFactoryReference(attributeValue)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFactoryReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static class JavaFXFactoryReference
    extends PsiReferenceBase<XmlAttributeValue> {
        public JavaFXFactoryReference(XmlAttributeValue attributeValue) {
            super((PsiElement)attributeValue);
        }

        @Nullable
        public PsiElement resolve() {
            PsiClass psiClass = JavaFxPsiUtil.getTagClass((XmlAttributeValue)this.getElement());
            if (psiClass != null) {
                PsiMethod[] psiMethods;
                for (PsiMethod method : psiMethods = psiClass.findMethodsByName(((XmlAttributeValue)this.getElement()).getValue(), false)) {
                    if (!JavaFXFactoryReference.isFactoryMethod(method)) continue;
                    return method;
                }
            }
            return null;
        }

        private static boolean isFactoryMethod(PsiMethod method) {
            return method.hasModifierProperty("static") && method.getParameterList().getParametersCount() == 0;
        }

        @NotNull
        public Object[] getVariants() {
            PsiClass psiClass = JavaFxPsiUtil.getTagClass((XmlAttributeValue)this.getElement());
            if (psiClass != null) {
                ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
                for (PsiMethod method : psiClass.getMethods()) {
                    if (!JavaFXFactoryReference.isFactoryMethod(method)) continue;
                    methods.add(method);
                }
                Object[] objectArray = ArrayUtil.toObjectArray(methods);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFactoryReferenceProvider$JavaFXFactoryReference", "getVariants"));
                }
                return objectArray;
            }
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFactoryReferenceProvider$JavaFXFactoryReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }
}

