/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.config.impl.AntClasspathEntry;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.FileAppearanceService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class SinglePathEntry
implements AntClasspathEntry {
    private static final Function<VirtualFile, AntClasspathEntry> CREATE_FROM_VIRTUAL_FILE = new Function<VirtualFile, AntClasspathEntry>(){

        public AntClasspathEntry fun(VirtualFile singlePathEntry) {
            return SinglePathEntry.fromVirtualFile(singlePathEntry);
        }
    };
    @NonNls
    static final String PATH = "path";
    private File myFile;

    public SinglePathEntry(File file) {
        this.myFile = file;
    }

    public SinglePathEntry(String osPath) {
        this(new File(osPath));
    }

    public void readExternal(Element element) {
        String value = element.getAttributeValue(PATH);
        this.myFile = new File(PathUtil.toPresentableUrl((String)value));
    }

    @Override
    public void writeExternal(Element element) {
        String url = VirtualFileManager.constructUrl((String)"file", (String)this.myFile.getAbsolutePath().replace(File.separatorChar, '/'));
        element.setAttribute(PATH, url);
    }

    @Override
    public void addFilesTo(List<File> files) {
        files.add(this.myFile);
    }

    @Override
    public CellAppearanceEx getAppearance() {
        return FileAppearanceService.getInstance().forIoFile(this.myFile);
    }

    private static SinglePathEntry fromVirtualFile(VirtualFile file) {
        return new SinglePathEntry(file.getPresentableUrl());
    }

    public static class AddEntriesFactory
    extends AntClasspathEntry.AddEntriesFactory {
        public AddEntriesFactory(JComponent parentComponent) {
            super(parentComponent, new FileChooserDescriptor(false, true, true, true, false, true), (Function<VirtualFile, AntClasspathEntry>)CREATE_FROM_VIRTUAL_FILE);
        }
    }
}

