/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBDispatcher {
    JAXBContext jc;

    public JAXBDispatcher(JAXBContext jc) {
        this.jc = jc;
    }

    public Object doGET(String url, Map<String, Object> httpHeaders, String expectedMimeType) throws MalformedURLException, IOException, JAXBException {
        URL u = new URL(url);
        URLConnection c = u.openConnection();
        InputStream in = null;
        String mediaType = null;
        if (c instanceof HttpURLConnection) {
            HttpURLConnection h = (HttpURLConnection)c;
            h.setRequestMethod("GET");
            h.setRequestProperty("Accept", expectedMimeType);
            for (String key : httpHeaders.keySet()) {
                h.setRequestProperty(key, httpHeaders.get(key).toString());
            }
            h.connect();
            mediaType = h.getContentType();
            in = h.getResponseCode() < 400 ? h.getInputStream() : h.getErrorStream();
        }
        Unmarshaller um = this.jc.createUnmarshaller();
        Object o = um.unmarshal(in);
        return o;
    }

    public Object doDELETE(String url, Map<String, Object> httpHeaders, String expectedMimeType) throws MalformedURLException, IOException, JAXBException {
        URL u = new URL(url);
        URLConnection c = u.openConnection();
        InputStream in = null;
        String mediaType = null;
        if (c instanceof HttpURLConnection) {
            HttpURLConnection h = (HttpURLConnection)c;
            h.setRequestMethod("DELETE");
            if (expectedMimeType != null) {
                h.setRequestProperty("Accept", expectedMimeType);
            }
            for (String key : httpHeaders.keySet()) {
                h.setRequestProperty(key, httpHeaders.get(key).toString());
            }
            h.connect();
            mediaType = h.getContentType();
            in = h.getResponseCode() < 400 ? h.getInputStream() : h.getErrorStream();
        }
        Unmarshaller um = this.jc.createUnmarshaller();
        Object o = um.unmarshal(in);
        return o;
    }

    public Object doPOST(Object input, String inputMimeType, String url, Map<String, Object> httpHeaders, String expectedMimeType) throws MalformedURLException, IOException, JAXBException {
        URL u = new URL(url);
        URLConnection c = u.openConnection();
        InputStream in = null;
        String mediaType = null;
        if (c instanceof HttpURLConnection) {
            HttpURLConnection h = (HttpURLConnection)c;
            h.setRequestMethod("POST");
            h.setChunkedStreamingMode(-1);
            h.setRequestProperty("Accept", expectedMimeType);
            h.setRequestProperty("Content-Type", inputMimeType);
            for (String key : httpHeaders.keySet()) {
                h.setRequestProperty(key, httpHeaders.get(key).toString());
            }
            h.setDoOutput(true);
            h.connect();
            OutputStream out = h.getOutputStream();
            Marshaller m = this.jc.createMarshaller();
            m.marshal(input, out);
            out.close();
            mediaType = h.getContentType();
            in = h.getResponseCode() < 400 ? h.getInputStream() : h.getErrorStream();
        }
        Unmarshaller um = this.jc.createUnmarshaller();
        Object o = um.unmarshal(in);
        return o;
    }

    public Object doPUT(Object input, String inputMimeType, String url, Map<String, Object> httpHeaders, String expectedMimeType) throws MalformedURLException, IOException, JAXBException {
        URL u = new URL(url);
        URLConnection c = u.openConnection();
        InputStream in = null;
        String mediaType = null;
        if (c instanceof HttpURLConnection) {
            HttpURLConnection h = (HttpURLConnection)c;
            h.setRequestMethod("PUT");
            h.setChunkedStreamingMode(-1);
            if (expectedMimeType != null) {
                h.setRequestProperty("Accept", expectedMimeType);
            }
            h.setRequestProperty("Content-Type", inputMimeType);
            for (String key : httpHeaders.keySet()) {
                h.setRequestProperty(key, httpHeaders.get(key).toString());
            }
            h.setDoOutput(true);
            h.connect();
            OutputStream out = h.getOutputStream();
            Marshaller m = this.jc.createMarshaller();
            m.marshal(input, out);
            out.close();
            mediaType = h.getContentType();
            in = h.getResponseCode() < 400 ? h.getInputStream() : h.getErrorStream();
        }
        Unmarshaller um = this.jc.createUnmarshaller();
        Object o = um.unmarshal(in);
        return o;
    }
}

