/*
 * Decompiled with CFR 0.152.
 */
package com.android.assetstudiolib.vectordrawable;

import com.android.assetstudiolib.vectordrawable.Svg2Vector;
import com.android.assetstudiolib.vectordrawable.SvgNode;
import com.android.assetstudiolib.vectordrawable.SvgTree;
import com.android.assetstudiolib.vectordrawable.VdParser;
import com.android.assetstudiolib.vectordrawable.VdPath;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

class SvgLeafNode
extends SvgNode {
    private static Logger logger = Logger.getLogger(SvgLeafNode.class.getSimpleName());
    private String mPathData;
    private HashMap<String, String> mVdAttributesMap = new HashMap();

    public SvgLeafNode(SvgTree svgTree, Node node, String nodeName) {
        super(svgTree, node, nodeName);
    }

    private String getAttributeValues(ImmutableMap<String, String> presentationMap) {
        StringBuilder sb = new StringBuilder("/>\n");
        for (String key : this.mVdAttributesMap.keySet()) {
            String attr;
            String vectorDrawableAttr = (String)presentationMap.get((Object)key);
            if (!"none".equals(this.mVdAttributesMap.get(key))) {
                attr = "\n        " + vectorDrawableAttr + "=\"" + this.mVdAttributesMap.get(key) + "\"";
                sb.insert(0, attr);
                continue;
            }
            attr = "\n        " + vectorDrawableAttr + "=\"#00000000\"";
            sb.insert(0, attr);
        }
        return sb.toString();
    }

    @Override
    public void dumpNode(String indent) {
        logger.log(Level.FINE, indent + (this.mPathData != null ? this.mPathData : " null pathData ") + (this.mName != null ? this.mName : " null name "));
    }

    public void setPathData(String pathData) {
        this.mPathData = pathData;
    }

    @Override
    public boolean isGroupNode() {
        return false;
    }

    @Override
    public void transform(float a, float b, float c, float d, float e, float f) {
        if ("none".equals(this.mVdAttributesMap.get("fill")) || this.mPathData == null) {
            return;
        }
        VdPath.Node[] n = VdParser.parsePath(this.mPathData);
        if (a != 1.0f || d != 1.0f || b != 0.0f || c != 0.0f || e != 0.0f || f != 0.0f) {
            VdPath.Node.transform(a, b, c, d, e, f, n);
        }
        this.mPathData = VdPath.Node.NodeListToString(n);
    }

    @Override
    public void writeXML(OutputStreamWriter writer) throws IOException {
        boolean nothingToDraw;
        String fillColor = this.mVdAttributesMap.get("fill");
        String strokeColor = this.mVdAttributesMap.get("stroke");
        logger.log(Level.FINE, "fill color " + fillColor);
        boolean emptyFill = fillColor != null && ("none".equals(fillColor) || "#0000000".equals(fillColor));
        boolean emptyStroke = strokeColor == null || "none".equals(strokeColor);
        boolean emptyPath = this.mPathData == null;
        boolean bl = nothingToDraw = emptyPath || emptyFill && emptyStroke;
        if (nothingToDraw) {
            return;
        }
        writer.write("    <path\n");
        if (!this.mVdAttributesMap.containsKey("fill")) {
            logger.log(Level.FINE, "ADDING FILL SVG_FILL_COLOR");
            writer.write("        android:fillColor=\"#FF000000\"\n");
        }
        writer.write("        android:pathData=\"" + this.mPathData + "\"");
        writer.write(this.getAttributeValues(Svg2Vector.presentationMap));
    }

    public void fillPresentationAttributes(String name, String value) {
        logger.log(Level.FINE, ">>>> PROP " + name + " = " + value);
        if (value.startsWith("url(")) {
            this.getTree().logErrorLine("Unsupported URL value: " + value, this.getDocumentNode(), SvgTree.SvgLogLevel.ERROR);
            return;
        }
        this.mVdAttributesMap.put(name, value);
    }
}

