/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsExecution;

import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.WaitForProgressToShow;
import org.jetbrains.annotations.NotNull;

public class ModalityContextImpl
implements ModalityContext {
    private final ModalityState myDefaultModalityState;
    public static final ModalityContext NON_MODAL = new ModalityContextImpl(ModalityState.NON_MODAL);

    public ModalityContextImpl(ModalityState defaultModalityState) {
        this.myDefaultModalityState = defaultModalityState;
    }

    public void runInDispatchThread(@NotNull Runnable action, Project project) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/cvsSupport2/cvsExecution/ModalityContextImpl", "runInDispatchThread"));
        }
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isDispatchThread()) {
            action.run();
        } else {
            WaitForProgressToShow.runOrInvokeAndWaitAboveProgress((Runnable)action, (ModalityState)this.getCurrentModalityState());
        }
    }

    private ModalityState getCurrentModalityState() {
        ModalityState modalityState;
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        ModalityState modalityState2 = modalityState = progressIndicator == null ? this.myDefaultModalityState : progressIndicator.getModalityState();
        if (modalityState == null) {
            modalityState = ModalityState.defaultModalityState();
        }
        return modalityState;
    }
}

