/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.inet;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.internal.id.IdGenerator;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.ConnectionAcceptor;
import org.gradle.messaging.remote.internal.ConnectCompletion;
import org.gradle.messaging.remote.internal.IncomingConnector;
import org.gradle.messaging.remote.internal.inet.InetAddressFactory;
import org.gradle.messaging.remote.internal.inet.MultiChoiceAddress;
import org.gradle.messaging.remote.internal.inet.SocketConnectCompletion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpIncomingConnector
implements IncomingConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpIncomingConnector.class);
    private final ExecutorFactory executorFactory;
    private final InetAddressFactory addressFactory;
    private final IdGenerator<?> idGenerator;

    public TcpIncomingConnector(ExecutorFactory executorFactory, InetAddressFactory addressFactory, IdGenerator<?> idGenerator) {
        this.executorFactory = executorFactory;
        this.addressFactory = addressFactory;
        this.idGenerator = idGenerator;
    }

    @Override
    public ConnectionAcceptor accept(Action<ConnectCompletion> action, boolean allowRemote) {
        int localPort;
        ServerSocketChannel serverSocket;
        try {
            serverSocket = ServerSocketChannel.open();
            serverSocket.socket().bind(new InetSocketAddress(this.addressFactory.findLocalBindingAddress(), 0));
            localPort = serverSocket.socket().getLocalPort();
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        Object id = this.idGenerator.generateId();
        List<InetAddress> addresses = allowRemote ? this.addressFactory.findRemoteAddresses() : this.addressFactory.findLocalAddresses();
        final MultiChoiceAddress address = new MultiChoiceAddress(id, localPort, addresses);
        LOGGER.debug("Listening on {}.", (Object)address);
        final StoppableExecutor executor = this.executorFactory.create(String.format("Incoming %s TCP Connector on port %s", allowRemote ? "remote" : "local", localPort));
        executor.execute((Runnable)new Receiver(serverSocket, action, allowRemote));
        return new ConnectionAcceptor(){

            public Address getAddress() {
                return address;
            }

            public void requestStop() {
                CompositeStoppable.stoppable((Object[])new Object[]{serverSocket}).stop();
            }

            public void stop() {
                this.requestStop();
                executor.stop();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Receiver
    implements Runnable {
        private final ServerSocketChannel serverSocket;
        private final Action<ConnectCompletion> action;
        private final boolean allowRemote;

        public Receiver(ServerSocketChannel serverSocket, Action<ConnectCompletion> action, boolean allowRemote) {
            this.serverSocket = serverSocket;
            this.action = action;
            this.allowRemote = allowRemote;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        SocketChannel socket = this.serverSocket.accept();
                        InetSocketAddress remoteSocketAddress = (InetSocketAddress)socket.socket().getRemoteSocketAddress();
                        InetAddress remoteInetAddress = remoteSocketAddress.getAddress();
                        if (!this.allowRemote && !TcpIncomingConnector.this.addressFactory.isLocal(remoteInetAddress)) {
                            LOGGER.error("Cannot accept connection from remote address {}.", (Object)remoteInetAddress);
                            socket.close();
                            continue;
                        }
                        LOGGER.debug("Accepted connection from {} to {}.", (Object)socket.socket().getRemoteSocketAddress(), (Object)socket.socket().getLocalSocketAddress());
                        this.action.execute((Object)new SocketConnectCompletion(socket));
                    }
                }
                catch (ClosedChannelException e) {
                }
                catch (Exception e) {
                    LOGGER.error("Could not accept remote connection.", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                CompositeStoppable.stoppable((Object[])new Object[]{this.serverSocket}).stop();
                throw throwable;
            }
            CompositeStoppable.stoppable((Object[])new Object[]{this.serverSocket}).stop();
        }
    }
}

