/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.google.common.base.Objects;
import com.intellij.execution.ExecutableValidator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.text.ParseException;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class GitVersion
implements Comparable<GitVersion> {
    public static final GitVersion MIN = new GitVersion(1, 7, 1, 1);
    public static final GitVersion NULL = new GitVersion(0, 0, 0, 0, Type.NULL);
    private static final Pattern FORMAT = Pattern.compile("git version (\\d+)\\.(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(.*)", 2);
    private static final Logger LOG = Logger.getInstance((String)GitVersion.class.getName());
    private final int myMajor;
    private final int myMinor;
    private final int myRevision;
    private final int myPatchLevel;
    private final Type myType;
    private final int myHashCode;

    public GitVersion(int major, int minor, int revision, int patchLevel, Type type) {
        this.myMajor = major;
        this.myMinor = minor;
        this.myRevision = revision;
        this.myPatchLevel = patchLevel;
        this.myType = type;
        this.myHashCode = Objects.hashCode((Object[])new Object[]{this.myMajor, this.myMinor, this.myRevision, this.myPatchLevel});
    }

    public GitVersion(int major, int minor, int revision, int patchLevel) {
        this(major, minor, revision, patchLevel, Type.UNDEFINED);
    }

    @NotNull
    public static GitVersion parse(String output) throws ParseException {
        boolean msys;
        if (StringUtil.isEmptyOrSpaces((String)output)) {
            throw new ParseException("Empty git --version output: " + output, 0);
        }
        Matcher m = FORMAT.matcher(output.trim());
        if (!m.matches()) {
            throw new ParseException("Unsupported format of git --version output: " + output, 0);
        }
        int major = GitVersion.getIntGroup(m, 1);
        int minor = GitVersion.getIntGroup(m, 2);
        int rev = GitVersion.getIntGroup(m, 3);
        int patch = GitVersion.getIntGroup(m, 4);
        boolean bl = msys = m.groupCount() >= 5 && m.group(5) != null && m.group(5).toLowerCase().contains("msysgit");
        Type type = SystemInfo.isWindows ? (msys ? Type.MSYS : Type.CYGWIN) : Type.UNIX;
        GitVersion gitVersion = new GitVersion(major, minor, rev, patch, type);
        if (gitVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/config/GitVersion", "parse"));
        }
        return gitVersion;
    }

    private static int getIntGroup(Matcher matcher, int group) {
        if (group > matcher.groupCount() + 1) {
            return 0;
        }
        String match = matcher.group(group);
        if (match == null) {
            return 0;
        }
        return Integer.parseInt(match);
    }

    @NotNull
    public static GitVersion identifyVersion(String gitExecutable) throws TimeoutException, ExecutionException, ParseException {
        ProcessOutput result;
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(gitExecutable);
        commandLine.addParameter("--version");
        CapturingProcessHandler handler = new CapturingProcessHandler(commandLine.createProcess(), CharsetToolkit.getDefaultSystemCharset());
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        ProcessOutput processOutput = result = indicator == null ? handler.runProcess(ExecutableValidator.TIMEOUT_MS) : handler.runProcessWithProgressIndicator(indicator);
        if (result.isTimeout()) {
            throw new TimeoutException("Couldn't identify the version of Git - stopped by timeout.");
        }
        if (result.isCancelled()) {
            LOG.info("Cancelled by user. exitCode=" + result.getExitCode());
            throw new ProcessCanceledException();
        }
        if (result.getExitCode() != 0 || !result.getStderr().isEmpty()) {
            LOG.info("getVersion exitCode=" + result.getExitCode() + " errors: " + result.getStderr());
            try {
                GitVersion.parse(result.getStdout());
            }
            catch (ParseException pe) {
                throw new ExecutionException("Errors while executing git --version. exitCode=" + result.getExitCode() + " errors: " + result.getStderr());
            }
        }
        GitVersion gitVersion = GitVersion.parse(result.getStdout());
        if (gitVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/config/GitVersion", "identifyVersion"));
        }
        return gitVersion;
    }

    public boolean isSupported() {
        return this.getType() != Type.NULL && this.compareTo(MIN) >= 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GitVersion)) {
            return false;
        }
        GitVersion other = (GitVersion)obj;
        if (this.compareTo(other) != 0) {
            return false;
        }
        if (this.myType == Type.UNDEFINED || other.myType == Type.UNDEFINED) {
            return true;
        }
        return this.myType == other.myType;
    }

    public int hashCode() {
        return this.myHashCode;
    }

    @Override
    public int compareTo(@NotNull GitVersion o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "git4idea/config/GitVersion", "compareTo"));
        }
        if (o.getType() == Type.NULL) {
            return this.getType() == Type.NULL ? 0 : 1;
        }
        int d = this.myMajor - o.myMajor;
        if (d != 0) {
            return d;
        }
        d = this.myMinor - o.myMinor;
        if (d != 0) {
            return d;
        }
        d = this.myRevision - o.myRevision;
        if (d != 0) {
            return d;
        }
        return this.myPatchLevel - o.myPatchLevel;
    }

    public String toString() {
        String msysIndicator = this.myType == Type.MSYS ? ".msysgit" : "";
        return this.myMajor + "." + this.myMinor + "." + this.myRevision + "." + this.myPatchLevel + msysIndicator;
    }

    public boolean isOlderOrEqual(GitVersion gitVersion) {
        return gitVersion != null && this.compareTo(gitVersion) <= 0;
    }

    public boolean isLaterOrEqual(GitVersion version) {
        return version != null && this.compareTo(version) >= 0;
    }

    public Type getType() {
        return this.myType;
    }

    public boolean isNull() {
        return this.getType() == Type.NULL;
    }

    public static enum Type {
        UNIX,
        MSYS,
        CYGWIN,
        UNDEFINED,
        NULL;

    }
}

