/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.instrumentation;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import sun.misc.Resource;

public class InstrumentationClassFinder {
    private static final PseudoClass[] EMPTY_PSEUDOCLASS_ARRAY = new PseudoClass[0];
    private static final String CLASS_RESOURCE_EXTENSION = ".class";
    private static final URL[] URL_EMPTY_ARRAY = new URL[0];
    private final Map<String, PseudoClass> myLoaded = new HashMap<String, PseudoClass>();
    private final ClassFinderClasspath myPlatformClasspath;
    private final ClassFinderClasspath myClasspath;
    private final URL[] myPlatformUrls;
    private final URL[] myClasspathUrls;
    private ClassLoader myLoader;
    private byte[] myBuffer;

    public InstrumentationClassFinder(URL[] cp) {
        this(URL_EMPTY_ARRAY, cp);
    }

    public InstrumentationClassFinder(URL[] platformUrls, URL[] classpathUrls) {
        this.myPlatformUrls = platformUrls;
        this.myClasspathUrls = classpathUrls;
        this.myPlatformClasspath = new ClassFinderClasspath(platformUrls);
        this.myClasspath = new ClassFinderClasspath(classpathUrls);
    }

    public ClassLoader getLoader() {
        ClassLoader loader = this.myLoader;
        if (loader != null) {
            return loader;
        }
        URLClassLoader platformLoader = this.myPlatformUrls.length > 0 ? new URLClassLoader(this.myPlatformUrls, null) : null;
        URLClassLoader cpLoader = new URLClassLoader(this.myClasspathUrls, (ClassLoader)platformLoader);
        this.myLoader = loader = new ClassLoader((ClassLoader)cpLoader){

            @Override
            public InputStream getResourceAsStream(String name) {
                InputStream is = null;
                is = super.getResourceAsStream(name);
                if (is == null) {
                    try {
                        is = InstrumentationClassFinder.this.getResourceAsStream(name);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return is;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Class findClass(String name) throws ClassNotFoundException {
                InputStream is = InstrumentationClassFinder.this.lookupClassBeforeClasspath(name.replace('.', '/'));
                if (is == null) {
                    throw new ClassNotFoundException("Class not found: " + name.replace('/', '.'));
                }
                try {
                    byte[] bytes = InstrumentationClassFinder.this.loadBytes(is);
                    Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
                    return clazz;
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        return loader;
    }

    public void releaseResources() {
        this.myPlatformClasspath.releaseResources();
        this.myClasspath.releaseResources();
        this.myLoaded.clear();
        this.myBuffer = null;
        this.myLoader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PseudoClass loadClass(String name) throws IOException, ClassNotFoundException {
        InputStream is;
        String internalName = name.replace('.', '/');
        PseudoClass aClass = this.myLoaded.get(internalName);
        if (aClass != null && aClass != PseudoClass.NULL_OBJ) {
            return aClass;
        }
        InputStream inputStream = is = aClass == null ? this.getClassBytesStream(internalName) : null;
        if (is == null) {
            if (aClass == null) {
                this.myLoaded.put(internalName, PseudoClass.NULL_OBJ);
            }
            throw new ClassNotFoundException("Class not found: " + name.replace('/', '.')){

                @Override
                public synchronized Throwable fillInStackTrace() {
                    return this;
                }
            };
        }
        try {
            PseudoClass result = this.loadPseudoClass(is);
            this.myLoaded.put(internalName, result);
            PseudoClass pseudoClass = result;
            return pseudoClass;
        }
        finally {
            is.close();
        }
    }

    public void cleanCachedData(String className) {
        this.myLoaded.remove(className.replace('.', '/'));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getClassBytesAsStream(String className) throws IOException {
        String internalName = className.replace('.', '/');
        PseudoClass aClass = this.myLoaded.get(internalName);
        if (aClass == PseudoClass.NULL_OBJ) {
            return null;
        }
        InputStream bytes = null;
        try {
            bytes = this.getClassBytesStream(internalName);
        }
        finally {
            if (aClass == null && bytes == null) {
                this.myLoaded.put(internalName, PseudoClass.NULL_OBJ);
            }
        }
        return bytes;
    }

    private InputStream getClassBytesStream(String internalName) throws IOException {
        InputStream is = null;
        String resourceName = internalName + CLASS_RESOURCE_EXTENSION;
        Resource resource = this.myPlatformClasspath.getResource(resourceName, false);
        if (resource != null) {
            is = new ByteArrayInputStream(resource.getBytes());
        }
        if (is == null) {
            is = this.lookupClassBeforeClasspath(internalName);
        }
        if (is == null && (resource = this.myClasspath.getResource(resourceName, false)) != null) {
            is = new ByteArrayInputStream(resource.getBytes());
        }
        if (is == null) {
            is = this.lookupClassAfterClasspath(internalName);
        }
        return is;
    }

    public InputStream getResourceAsStream(String resourceName) throws IOException {
        ByteArrayInputStream is = null;
        Resource resource = this.myPlatformClasspath.getResource(resourceName, false);
        if (resource != null) {
            is = new ByteArrayInputStream(resource.getBytes());
        }
        if (is == null && (resource = this.myClasspath.getResource(resourceName, false)) != null) {
            is = new ByteArrayInputStream(resource.getBytes());
        }
        return is;
    }

    protected InputStream lookupClassBeforeClasspath(String internalClassName) {
        return null;
    }

    protected InputStream lookupClassAfterClasspath(String internalClassName) {
        return null;
    }

    private PseudoClass loadPseudoClass(InputStream is) throws IOException {
        ClassReader reader = new ClassReader(is);
        V visitor = new V();
        reader.accept((ClassVisitor)visitor, 7);
        return new PseudoClass(this, visitor.myName, visitor.mySuperclassName, visitor.myInterfaces, visitor.myModifiers, visitor.myMethods);
    }

    private static String unescapePercentSequences(String s) {
        if (s.indexOf(37) == -1) {
            return s;
        }
        StringBuilder decoded = new StringBuilder();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '%') {
                ArrayList<Integer> bytes = new ArrayList<Integer>();
                while (i + 2 < len && s.charAt(i) == '%') {
                    int d1 = InstrumentationClassFinder.decode(s.charAt(i + 1));
                    int d2 = InstrumentationClassFinder.decode(s.charAt(i + 2));
                    if (d1 == -1 || d2 == -1) break;
                    bytes.add((d1 & 0xF) << 4 | d2 & 0xF);
                    i += 3;
                }
                if (!bytes.isEmpty()) {
                    byte[] bytesArray = new byte[bytes.size()];
                    for (int j = 0; j < bytes.size(); ++j) {
                        bytesArray[j] = (byte)((Integer)bytes.get(j)).intValue();
                    }
                    try {
                        decoded.append(new String(bytesArray, "UTF-8"));
                        continue;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
            }
            decoded.append(c);
            ++i;
        }
        return decoded.toString();
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    public byte[] loadBytes(InputStream stream) {
        byte[] buf = this.myBuffer;
        if (buf == null) {
            this.myBuffer = buf = new byte[512];
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            int n;
            while ((n = stream.read(buf, 0, buf.length)) > 0) {
                result.write(buf, 0, n);
            }
            result.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.toByteArray();
    }

    static class ClassFinderClasspath {
        private static final String FILE_PROTOCOL = "file";
        private final Stack<URL> myUrls = new Stack();
        private final List<Loader> myLoaders = new ArrayList<Loader>();
        private final Map<URL, Loader> myLoadersMap = new HashMap<URL, Loader>();

        public ClassFinderClasspath(URL[] urls) {
            if (urls.length > 0) {
                for (int i = urls.length - 1; i >= 0; --i) {
                    this.myUrls.push(urls[i]);
                }
            }
        }

        public Resource getResource(String s, boolean flag) {
            Loader loader;
            int i = 0;
            while ((loader = this.getLoader(i)) != null) {
                Resource resource = loader.getResource(s, flag);
                if (resource != null) {
                    return resource;
                }
                ++i;
            }
            return null;
        }

        public void releaseResources() {
            for (Loader loader : this.myLoaders) {
                loader.releaseResources();
            }
            this.myLoaders.clear();
            this.myLoadersMap.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized Loader getLoader(int i) {
            while (this.myLoaders.size() < i + 1) {
                Loader loader;
                URL url;
                Stack<URL> stack = this.myUrls;
                synchronized (stack) {
                    if (this.myUrls.empty()) {
                        return null;
                    }
                    url = this.myUrls.pop();
                }
                if (this.myLoadersMap.containsKey(url)) continue;
                try {
                    loader = this.getLoader(url, this.myLoaders.size());
                    if (loader == null) {
                    }
                }
                catch (IOException ioexception) {}
                continue;
                this.myLoaders.add(loader);
                this.myLoadersMap.put(url, loader);
            }
            return this.myLoaders.get(i);
        }

        private Loader getLoader(URL url, int index) throws IOException {
            String s;
            try {
                s = url.toURI().getSchemeSpecificPart();
            }
            catch (URISyntaxException thisShouldNotHappen) {
                thisShouldNotHappen.printStackTrace();
                s = url.getFile();
            }
            Loader loader = null;
            if (s != null && new File(s).isDirectory()) {
                if (FILE_PROTOCOL.equals(url.getProtocol())) {
                    loader = new FileLoader(url, index);
                }
            } else {
                loader = new JarLoader(url, index);
            }
            return loader;
        }

        private class JarLoader
        extends Loader {
            private final URL myURL;
            private ZipFile myZipFile;

            JarLoader(URL url, int index) throws IOException {
                super(new URL("jar", "", -1, url + "!/"), index);
                this.myURL = url;
            }

            @Override
            public void releaseResources() {
                ZipFile zipFile = this.myZipFile;
                if (zipFile != null) {
                    this.myZipFile = null;
                    try {
                        zipFile.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException();
                    }
                }
            }

            private ZipFile acquireZipFile() throws IOException {
                ZipFile zipFile = this.myZipFile;
                if (zipFile == null) {
                    this.myZipFile = zipFile = this.doGetZipFile();
                }
                return zipFile;
            }

            private ZipFile doGetZipFile() throws IOException {
                if (ClassFinderClasspath.FILE_PROTOCOL.equals(this.myURL.getProtocol())) {
                    String s = InstrumentationClassFinder.unescapePercentSequences(this.myURL.getFile().replace('/', File.separatorChar));
                    if (!new File(s).exists()) {
                        throw new FileNotFoundException(s);
                    }
                    return new ZipFile(s);
                }
                return null;
            }

            @Override
            public Resource getResource(String name, boolean flag) {
                try {
                    ZipEntry entry;
                    ZipFile file = this.acquireZipFile();
                    if (file != null && (entry = file.getEntry(name)) != null) {
                        return new JarResource(entry, new URL(this.getBaseURL(), name));
                    }
                }
                catch (Exception e) {
                    return null;
                }
                return null;
            }

            public String toString() {
                return "JarLoader [" + this.myURL + "]";
            }

            private class JarResource
            extends Resource {
                private final ZipEntry myEntry;
                private final URL myUrl;

                public JarResource(ZipEntry name, URL url) {
                    this.myEntry = name;
                    this.myUrl = url;
                }

                public String getName() {
                    return this.myEntry.getName();
                }

                public URL getURL() {
                    return this.myUrl;
                }

                public URL getCodeSourceURL() {
                    return JarLoader.this.myURL;
                }

                public InputStream getInputStream() throws IOException {
                    try {
                        ZipFile file = JarLoader.this.acquireZipFile();
                        if (file == null) {
                            return null;
                        }
                        InputStream inputStream = file.getInputStream(this.myEntry);
                        if (inputStream == null) {
                            return null;
                        }
                        return new FilterInputStream(inputStream){};
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                }

                public int getContentLength() {
                    return (int)this.myEntry.getSize();
                }
            }
        }

        private static class FileLoader
        extends Loader {
            private final File myRootDir;

            FileLoader(URL url, int index) throws IOException {
                super(url, index);
                if (!ClassFinderClasspath.FILE_PROTOCOL.equals(url.getProtocol())) {
                    throw new IllegalArgumentException("url");
                }
                String s = InstrumentationClassFinder.unescapePercentSequences(url.getFile().replace('/', File.separatorChar));
                this.myRootDir = new File(s);
            }

            @Override
            public void releaseResources() {
            }

            @Override
            public Resource getResource(String name, boolean check) {
                block6: {
                    URL url = null;
                    File file = null;
                    try {
                        url = new URL(this.getBaseURL(), name);
                        if (!url.getFile().startsWith(this.getBaseURL().getFile())) {
                            return null;
                        }
                        file = new File(this.myRootDir, name.replace('/', File.separatorChar));
                        if (!check || file.exists()) {
                            return new FileResource(name, url, file, !check);
                        }
                    }
                    catch (Exception exception) {
                        if (check || file == null || !file.exists()) break block6;
                        try {
                            return new FileResource(name, url, file, false);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                return null;
            }

            public String toString() {
                return "FileLoader [" + this.myRootDir + "]";
            }

            private class FileResource
            extends Resource {
                private final String myName;
                private final URL myUrl;
                private final File myFile;

                public FileResource(String name, URL url, File file, boolean willLoadBytes) throws IOException {
                    this.myName = name;
                    this.myUrl = url;
                    this.myFile = file;
                    if (willLoadBytes) {
                        this.getByteBuffer();
                    }
                }

                public String getName() {
                    return this.myName;
                }

                public URL getURL() {
                    return this.myUrl;
                }

                public URL getCodeSourceURL() {
                    return FileLoader.this.getBaseURL();
                }

                public InputStream getInputStream() throws IOException {
                    return new BufferedInputStream(new FileInputStream(this.myFile));
                }

                public int getContentLength() throws IOException {
                    return -1;
                }

                public String toString() {
                    return this.myFile.getAbsolutePath();
                }
            }
        }

        private static abstract class Loader {
            protected static final String JAR_PROTOCOL = "jar";
            protected static final String FILE_PROTOCOL = "file";
            private final URL myURL;
            private final int myIndex;

            protected Loader(URL url, int index) {
                this.myURL = url;
                this.myIndex = index;
            }

            protected URL getBaseURL() {
                return this.myURL;
            }

            public abstract Resource getResource(String var1, boolean var2);

            public abstract void releaseResources();

            public int getIndex() {
                return this.myIndex;
            }
        }
    }

    private static class V
    extends ClassVisitor {
        public String mySuperclassName = null;
        public String[] myInterfaces = null;
        public String myName = null;
        public int myModifiers;
        private final List<PseudoMethod> myMethods = new ArrayList<PseudoMethod>();

        private V() {
            super(327680);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ((access & 1) > 0) {
                this.myMethods.add(new PseudoMethod(access, name, desc));
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        public void visit(int version, int access, String pName, String signature, String pSuperName, String[] pInterfaces) {
            this.mySuperclassName = pSuperName;
            this.myInterfaces = pInterfaces;
            this.myName = pName;
            this.myModifiers = access;
        }
    }

    public static final class PseudoMethod {
        private final int myAccess;
        private final String myName;
        private final String mySignature;

        public PseudoMethod(int access, String name, String signature) {
            this.myAccess = access;
            this.myName = name;
            this.mySignature = signature;
        }

        public int getModifiers() {
            return this.myAccess;
        }

        public String getName() {
            return this.myName;
        }

        public String getSignature() {
            return this.mySignature;
        }
    }

    public static class PseudoClass {
        static final PseudoClass NULL_OBJ = new PseudoClass(null, null, null, null, 0, null);
        private final String myName;
        private final String mySuperClass;
        private final String[] myInterfaces;
        private final int myModifiers;
        private final List<PseudoMethod> myMethods;
        private final InstrumentationClassFinder myFinder;

        private PseudoClass(InstrumentationClassFinder finder, String name, String superClass, String[] interfaces, int modifiers, List<PseudoMethod> methods) {
            this.myName = name;
            this.mySuperClass = superClass;
            this.myInterfaces = interfaces;
            this.myModifiers = modifiers;
            this.myMethods = methods;
            this.myFinder = finder;
        }

        public int getModifiers() {
            return this.myModifiers;
        }

        public boolean isInterface() {
            return (this.myModifiers & 0x200) > 0;
        }

        public String getName() {
            return this.myName;
        }

        public List<PseudoMethod> getMethods() {
            return this.myMethods;
        }

        public List<PseudoMethod> findMethods(String name) {
            ArrayList<PseudoMethod> result = new ArrayList<PseudoMethod>();
            for (PseudoMethod method : this.myMethods) {
                if (!method.getName().equals(name)) continue;
                result.add(method);
            }
            return result;
        }

        public PseudoMethod findMethod(String name, String descriptor) {
            for (PseudoMethod method : this.myMethods) {
                if (!method.getName().equals(name) || !method.getSignature().equals(descriptor)) continue;
                return method;
            }
            return null;
        }

        public PseudoMethod findMethodInHierarchy(String name, String descriptor) throws IOException, ClassNotFoundException {
            for (PseudoClass c = this; c != null; c = c.getSuperClass()) {
                PseudoMethod method = c.findMethod(name, descriptor);
                if (method == null) continue;
                return method;
            }
            for (PseudoClass iface : this.getInterfaces()) {
                PseudoMethod method = PseudoClass.findInterfaceMethodRecursively(iface, name, descriptor);
                if (method == null) continue;
                return method;
            }
            return null;
        }

        private static PseudoMethod findInterfaceMethodRecursively(PseudoClass fromIface, String name, String descriptor) throws IOException, ClassNotFoundException {
            PseudoMethod method = fromIface.findMethod(name, descriptor);
            if (method != null) {
                return method;
            }
            for (PseudoClass superIface : fromIface.getInterfaces()) {
                method = PseudoClass.findInterfaceMethodRecursively(superIface, name, descriptor);
                if (method == null) continue;
                return method;
            }
            return null;
        }

        public InstrumentationClassFinder getFinder() {
            return this.myFinder;
        }

        public PseudoClass getSuperClass() throws IOException, ClassNotFoundException {
            String superClass = this.mySuperClass;
            return superClass != null ? this.myFinder.loadClass(superClass) : null;
        }

        public PseudoClass[] getInterfaces() throws IOException, ClassNotFoundException {
            if (this.myInterfaces == null) {
                return EMPTY_PSEUDOCLASS_ARRAY;
            }
            PseudoClass[] result = new PseudoClass[this.myInterfaces.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.myFinder.loadClass(this.myInterfaces[i]);
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.getName().equals(((PseudoClass)o).getName());
        }

        private boolean isSubclassOf(PseudoClass x) throws IOException, ClassNotFoundException {
            for (PseudoClass c = this; c != null; c = c.getSuperClass()) {
                PseudoClass superClass = c.getSuperClass();
                if (superClass == null || !superClass.equals(x)) continue;
                return true;
            }
            return false;
        }

        private boolean implementsInterface(PseudoClass x) throws IOException, ClassNotFoundException {
            for (PseudoClass c = this; c != null; c = c.getSuperClass()) {
                PseudoClass[] tis;
                for (PseudoClass ti : tis = c.getInterfaces()) {
                    if (!ti.equals(x) && !ti.implementsInterface(x)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isAssignableFrom(PseudoClass x) throws IOException, ClassNotFoundException {
            if (this.equals(x)) {
                return true;
            }
            if (x.isSubclassOf(this)) {
                return true;
            }
            if (x.implementsInterface(this)) {
                return true;
            }
            return x.isInterface() && "java/lang/Object".equals(this.getName());
        }

        public boolean hasDefaultPublicConstructor() {
            for (PseudoMethod method : this.myMethods) {
                if (!"<init>".equals(method.getName()) || !"()V".equals(method.getSignature())) continue;
                return true;
            }
            return false;
        }

        public String getDescriptor() {
            return "L" + this.myName + ";";
        }
    }
}

